/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.bjno.j106.file.J106FileFilter;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;

public class BinarySysexFileImportHandler
extends JFileChooser {
    J106FileFilter filtersyx;
    Core core;

    public BinarySysexFileImportHandler(Core c) {
        super("./");
        this.setMultiSelectionEnabled(true);
        this.filtersyx = new J106FileFilter();
        this.filtersyx.addExtension("syx");
        this.filtersyx.setDescription("Binary sysex file");
        this.setFileFilter(this.filtersyx);
        this.core = c;
    }

    public ExtendedLibrary importMultipleSysexDialogue() {
        if (this.showOpenDialog(this.core.mainFrame) == 0) {
            File[] files = this.getSelectedFiles();
            ExtendedPatch p = null;
            ExtendedLibrary l = new ExtendedLibrary();
            for (int k = 0; k < files.length; ++k) {
                String tmp = files[k].getAbsolutePath();
                String localname = files[k].getName();
                if (localname.length() <= 4) continue;
                String originalName = localname;
                if (localname.substring(localname.length() - 4, localname.length()).equals(".syx")) {
                    localname = localname.substring(0, localname.length() - 4);
                }
                if ((p = this.importFromSysexFile(tmp)) == null) {
                    JOptionPane.showMessageDialog(this.core.mainFrame, "Failure when importing file " + originalName + ". Aborting operation.");
                    return null;
                }
                p.setName(localname);
                l.addPatchClever(p);
            }
            return l;
        }
        return null;
    }

    public void exportDialogue(ExtendedPatch aPatch) {
        this.setSelectedFile(new File(aPatch.getName() + ".syx"));
        int returnVal = this.showSaveDialog(this.core.mainFrame);
        if (returnVal == 0) {
            String tmp = this.getSelectedFile().getAbsolutePath();
            if (!tmp.substring(tmp.length() - 4, tmp.length()).equals(".syx")) {
                tmp = tmp.concat(".syx");
                this.setSelectedFile(new File(this.getSelectedFile().getAbsolutePath() + ".syx"));
            }
            BinarySysexFileImportHandler.writefile(this.getSelectedFile(), aPatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writefile(File fileOut, ExtendedPatch aPatch) {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(fileOut));
            out.write(Core.patchToMidiSysex(aPatch, 0));
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedPatch importFromSysexFile(String filename) {
        FilterInputStream inputStream = null;
        int[] temp = new int[24];
        int nRead = 0;
        try {
            inputStream = new DataInputStream(new FileInputStream(filename));
            for (int i = 0; i < 24; ++i) {
                if (inputStream.available() <= 0) continue;
                int t = ((DataInputStream)inputStream).readByte();
                if (t < 0) {
                    t += 256;
                }
                temp[i] = t;
                ++nRead;
            }
        }
        catch (IOException e) {
            ExtendedPatch t = null;
            return t;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (nRead != 24) {
            return null;
        }
        if (temp[0] != 240 || temp[23] != 247 || temp[1] != 65) {
            return null;
        }
        ExtendedPatch p = new ExtendedPatch();
        int index = 0;
        for (int k = 5; k < 23; ++k) {
            if (temp[k] > 127) {
                return null;
            }
            p.set((byte)temp[k], index);
            ++index;
        }
        return p;
    }
}

