/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.file;

import java.io.File;
import javax.swing.JFileChooser;
import org.bjno.j106.file.J106FileFilter;
import org.bjno.j106.file.J106IOWrapper;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;

public class FileHandler
extends JFileChooser {
    J106FileFilter filter = new J106FileFilter();
    J106FileFilter filtersyx;
    Core core;
    J106IOWrapper fileIo;
    String temporaryFilename = "New Library";

    public FileHandler(Core c) {
        super("./");
        this.filter.addExtension("106");
        this.filter.setDescription("Juno-106 Library");
        this.setFileFilter(this.filter);
        this.core = c;
        this.fileIo = new J106IOWrapper(c);
    }

    public void setDefault() {
        this.setSelectedFile(new File(""));
        this.setSelectedFile(null);
    }

    public boolean saveLibrary(ExtendedLibrary l) {
        if (this.getSelectedFile() == null) {
            return this.saveLibraryDialogue(l);
        }
        return this.fileIo.saveFile(this.getSelectedFile().getAbsolutePath(), l);
    }

    public boolean saveLibraryDialogue(ExtendedLibrary l) {
        File fmemory = this.getSelectedFile();
        File dmemory = this.getCurrentDirectory();
        int returnVal = this.showSaveDialog(this.core.mainFrame);
        if (returnVal == 0) {
            String tmp = this.getSelectedFile().getAbsolutePath();
            if (!tmp.substring(tmp.length() - 4, tmp.length()).equals(".106")) {
                tmp = tmp.concat(".106");
                this.setSelectedFile(new File(this.getSelectedFile().getAbsolutePath() + ".106"));
            }
            this.fileIo.saveFile(tmp, l);
            fmemory = this.getSelectedFile();
            dmemory = this.getCurrentDirectory();
            Core.debugPrint("Library " + l.getName() + " saved to file " + tmp);
        }
        if (fmemory == null) {
            this.setSelectedFile(new File(""));
            this.setSelectedFile(null);
        } else {
            this.setSelectedFile(fmemory);
        }
        this.setCurrentDirectory(dmemory);
        return returnVal == 0;
    }

    public ExtendedLibrary loadLibraryDialogue() {
        File fmemory = this.getSelectedFile();
        File dmemory = this.getCurrentDirectory();
        int returnVal = this.showOpenDialog(this.core.mainFrame);
        ExtendedLibrary loadedLibrary = null;
        if (returnVal == 0) {
            String tmp = this.getSelectedFile().getAbsolutePath();
            loadedLibrary = this.fileIo.loadFile(tmp);
            fmemory = this.getSelectedFile();
            dmemory = this.getCurrentDirectory();
        } else {
            loadedLibrary = null;
            Core.debugPrint("File choose operation cancelled");
        }
        if (fmemory == null) {
            this.setSelectedFile(new File(""));
            this.setSelectedFile(null);
        } else {
            this.setSelectedFile(fmemory);
        }
        this.setCurrentDirectory(dmemory);
        return loadedLibrary;
    }

    public void setTemporaryFilename(String s) {
        this.temporaryFilename = s;
    }

    public String getLocalFileName() {
        if (this.getSelectedFile() == null) {
            return this.temporaryFilename;
        }
        return this.getSelectedFile().getName();
    }

    public ExtendedLibrary loadLibraryDialogueMerge() {
        File fmemory = this.getSelectedFile();
        File dir = this.getCurrentDirectory();
        ExtendedLibrary loadedLibrary = this.loadLibraryDialogue();
        if (fmemory == null) {
            this.setSelectedFile(new File(""));
            this.setSelectedFile(null);
        } else {
            this.setSelectedFile(fmemory);
        }
        this.setCurrentDirectory(dir);
        return loadedLibrary;
    }
}

