/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.DataFormatException;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;

public class J106CurrentFileIO {
    private byte[] magicNumbers = new byte[]{33, 106, 49, 48, 54, 92};
    private int major = 3;
    private int minor = 1;
    private byte[] ending = new byte[]{22, 87, 73, 106};

    public J106CurrentFileIO(Core aCore) {
        if (aCore == null) {
            throw new RuntimeException("Cannot initialize without valid " + Core.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkHeader(String filename) {
        FilterInputStream inputStream = null;
        try {
            boolean i;
            inputStream = new DataInputStream(new FileInputStream(filename));
            for (i = false; i < this.magicNumbers.length; i += 1) {
                if (((DataInputStream)inputStream).readByte() == this.magicNumbers[i]) continue;
                boolean bl = false;
                return bl;
            }
            if (!this.readUTF8((DataInputStream)inputStream).equals("Library")) {
                i = false;
                return i;
            }
            i = true;
            return i;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void writeUTF8(DataOutputStream out, String aString) throws IOException {
        byte[] bytes = aString.getBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private String readUTF8(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return new String(bytes, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveLibrary(String filename, ExtendedLibrary library) {
        FilterOutputStream out = null;
        try {
            CRC32 crc = new CRC32();
            out = new DataOutputStream(new CheckedOutputStream(new FileOutputStream(filename), crc));
            long saveTime = System.currentTimeMillis();
            out.write(this.magicNumbers);
            this.writeUTF8((DataOutputStream)out, "Library");
            ((DataOutputStream)out).writeInt(this.major);
            ((DataOutputStream)out).writeInt(this.minor);
            this.writeUTF8((DataOutputStream)out, library.getName());
            ((DataOutputStream)out).writeLong(library.size());
            ((DataOutputStream)out).writeLong(saveTime);
            ((DataOutputStream)out).writeLong(crc.getValue());
            crc.reset();
            for (int i = 0; i < library.size(); ++i) {
                this.writeUTF8((DataOutputStream)out, library.getPatch(i).getName());
                this.writeUTF8((DataOutputStream)out, library.getPatch(i).getUid());
                ((DataOutputStream)out).writeLong(library.getPatch(i).getCreationTime());
                this.writeData((DataOutputStream)out, library.getPatch(i).getSysex(), 18, i);
                ((DataOutputStream)out).writeLong(crc.getValue());
                crc.reset();
            }
            out.write(this.ending);
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeData(DataOutputStream out, byte[] data, int length, int key) throws IOException {
        byte[] lookup = new byte[]{34, 68, 40, 103, 61, 43, 49, 45, 71, 124, 6, 50, 46, 50, 32, 104};
        int offset = (key + 79) * 137 - 31;
        for (int i = 0; i < length; ++i) {
            out.writeShort(data[i] * lookup[(i + offset) % 16]);
        }
    }

    private byte[] readData(DataInputStream in, int length, int key) throws IOException {
        byte[] lookup = new byte[]{34, 68, 40, 103, 61, 43, 49, 45, 71, 124, 6, 50, 46, 50, 32, 104};
        byte[] result = new byte[18];
        int offset = (key + 79) * 137 - 31;
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(in.readShort() / lookup[(i + offset) % 16]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedLibrary loadLibrary(String filename) {
        FilterInputStream inputStream = null;
        try {
            CRC32 crc = new CRC32();
            inputStream = new DataInputStream(new CheckedInputStream(new FileInputStream(filename), crc));
            for (int i = 0; i < this.magicNumbers.length; ++i) {
                if (((DataInputStream)inputStream).readByte() == this.magicNumbers[i]) continue;
                throw new DataFormatException("Magic numbers mismatch");
            }
            if (!this.readUTF8((DataInputStream)inputStream).equals("Library")) {
                throw new DataFormatException("Header error");
            }
            int majorVersion = ((DataInputStream)inputStream).readInt();
            int minorVersion = ((DataInputStream)inputStream).readInt();
            if (majorVersion != 3) {
                throw new DataFormatException();
            }
            ExtendedLibrary loadedLibrary = new ExtendedLibrary(this.readUTF8((DataInputStream)inputStream));
            long size = ((DataInputStream)inputStream).readLong();
            long libraryTime = ((DataInputStream)inputStream).readLong();
            long crcVal = crc.getValue();
            if (((DataInputStream)inputStream).readLong() != crcVal) {
                throw new DataFormatException();
            }
            crc.reset();
            int i = 0;
            while ((long)i < size) {
                String name = this.readUTF8((DataInputStream)inputStream);
                String uid = null;
                if (minorVersion == 1) {
                    uid = this.readUTF8((DataInputStream)inputStream);
                }
                long creationTime = ((DataInputStream)inputStream).readLong();
                byte[] sysex = this.readData((DataInputStream)inputStream, 18, i);
                ExtendedPatch loadedPatch = new ExtendedPatch(name, sysex, uid, creationTime);
                crcVal = crc.getValue();
                if (((DataInputStream)inputStream).readLong() != crcVal) {
                    throw new DataFormatException();
                }
                crc.reset();
                loadedLibrary.addPatch(loadedPatch);
                ++i;
            }
            for (i = 0; i < this.ending.length; ++i) {
                if (((DataInputStream)inputStream).readByte() == this.ending[i]) continue;
                throw new DataFormatException();
            }
            if (inputStream.available() != 0) {
                throw new DataFormatException();
            }
            ExtendedLibrary extendedLibrary = loadedLibrary;
            return extendedLibrary;
        }
        catch (DataFormatException e) {
            ExtendedLibrary extendedLibrary = null;
            return extendedLibrary;
        }
        catch (IOException e) {
            ExtendedLibrary extendedLibrary = null;
            return extendedLibrary;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

