/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.file;

import javax.swing.JOptionPane;
import org.bjno.j106.file.J106CurrentFileIO;
import org.bjno.j106.file.J106LegacyFileIO;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;

public class J106IOWrapper {
    J106LegacyFileIO legacyFileIO;
    J106CurrentFileIO currentFileIO;
    Core core;
    String betaBackwardsCompatibilityMessage = "The file is saved using an old file format (from v2.0) which will\nno longer be supported in a future release. Please save the file \nso that the file format is updated. For questions, please reach out to\njuno106librarian@gmail.com";

    public J106IOWrapper(Core aCore) {
        this.core = aCore;
        this.legacyFileIO = new J106LegacyFileIO(aCore);
        this.currentFileIO = new J106CurrentFileIO(aCore);
    }

    public ExtendedLibrary loadFile(String filename) {
        ExtendedLibrary toReturn;
        if (this.currentFileIO.checkHeader(filename)) {
            Core.debugPrint("Loading new file format");
            toReturn = this.currentFileIO.loadLibrary(filename);
            if (toReturn != null) {
                return toReturn;
            }
        }
        if (this.legacyFileIO.checkHeader(filename)) {
            Core.debugPrint("Loading legacy file format");
            JOptionPane.showMessageDialog(this.core.junoGui, this.betaBackwardsCompatibilityMessage, "File format issue.", 1);
            toReturn = this.legacyFileIO.loadLibrary(filename);
            if (toReturn != null) {
                return toReturn;
            }
        }
        JOptionPane.showMessageDialog(this.core.junoGui, "Unrecognized file format, or corrupt file.", "File format issue.", 0);
        return null;
    }

    public boolean saveFile(String filename, ExtendedLibrary library) {
        Core.debugPrint("Saving current file format");
        return this.currentFileIO.saveLibrary(filename, library);
    }

    public boolean isLegacyFile(String filename) {
        return this.legacyFileIO.checkHeader(filename);
    }
}

