/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.file;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;

public class J106LegacyFileIO {
    Core core;
    private static final byte[] classNameHeader = new byte[]{-84, -19, 0, 5, 115, 114};
    private static final byte[] libraryNameHeader = new byte[]{2, 0, 2, 76, 0, 4, 110, 97, 109, 101, 116, 0, 18, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 83, 116, 114, 105, 110, 103, 59, 76, 0, 1, 118, 116, 0, 18, 76, 106, 97, 118, 97, 47, 117, 116, 105, 108, 47, 86, 101, 99, 116, 111, 114, 59, 120, 112, 116};
    private static final byte[] librarySizeHeader = new byte[]{115, 114, 0, 16, 106, 97, 118, 97, 46, 117, 116, 105, 108, 46, 86, 101, 99, 116, 111, 114, -39, -105, 125, 91, -128, 59, -81, 1, 3, 0, 3, 73, 0, 17, 99, 97, 112, 97, 99, 105, 116, 121, 73, 110, 99, 114, 101, 109, 101, 110, 116, 73, 0, 12, 101, 108, 101, 109, 101, 110, 116, 67, 111, 117, 110, 116, 91, 0, 11, 101, 108, 101, 109, 101, 110, 116, 68, 97, 116, 97, 116, 0, 19, 91, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 59, 120, 112};
    private static final byte[] capacityHeader = new byte[]{117, 114, 0, 19, 91, 76, 106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 79, 98, 106, 101, 99, 116, 59, -112, -50, 88, -97, 16, 115, 41, 108, 2, 0, 0, 120, 112};
    private static final byte[] classHeader2 = new byte[]{115, 114};
    private static final byte[] firstPatchHeader = new byte[]{2, 0, 2, 76, 0, 4, 110, 97, 109, 101, 113, 0, 126, 0, 1, 91, 0, 5, 115, 121, 115, 101, 120, 116, 0, 2, 91, 66, 120, 112, 116};
    private static final byte[] firstSysexHeader = new byte[]{117, 114, 0, 2, 91, 66, -84, -13, 23, -8, 6, 8, 84, -32, 2, 0, 0, 120, 112, 0, 0, 0, 18};
    private static final byte[] intermediatePatchHeader = new byte[]{115, 113, 0, 126, 0, 10, 116};
    private static final byte[] intermediateSysexHeader = new byte[]{117, 113, 0, 126, 0, 14, 0, 0, 0, 18};

    public J106LegacyFileIO(Core aCore) {
        if (aCore == null) {
            throw new RuntimeException("Cannot initialize without valid " + Core.class);
        }
        this.core = aCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkHeader(String filename) {
        FilterInputStream inputStream = null;
        try {
            boolean i;
            inputStream = new DataInputStream(new FileInputStream(filename));
            for (i = false; i < classNameHeader.length; i += 1) {
                if (((DataInputStream)inputStream).readByte() == classNameHeader[i]) continue;
                boolean bl = false;
                return bl;
            }
            if (!((DataInputStream)inputStream).readUTF().equals("Library")) {
                i = false;
                return i;
            }
            i = true;
            return i;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    @Deprecated
    public ExtendedLibrary loadLibrary(String filename) {
        Class<?> legacyLibrary = null;
        try {
            legacyLibrary = Class.forName("Library");
        }
        catch (ClassNotFoundException e) {
            Core.debugPrint("Legacy file: ClassNotFoundException");
            return null;
        }
        Method fooMethod = null;
        try {
            fooMethod = legacyLibrary.getMethod("load", String.class);
        }
        catch (NoSuchMethodException e) {
            Core.debugPrint("Legacy file: NoSuchMethodException");
            return null;
        }
        catch (SecurityException e) {
            Core.debugPrint("Legacy file: SecurityException");
            return null;
        }
        Object loaded = null;
        try {
            loaded = fooMethod.invoke(legacyLibrary.newInstance(), filename);
        }
        catch (IllegalAccessException e) {
            Core.debugPrint("Legacy file: IllegalAccessException");
            return null;
        }
        catch (IllegalArgumentException e) {
            Core.debugPrint("Legacy file: IllegalArgumentException");
            return null;
        }
        catch (InvocationTargetException e) {
            Core.debugPrint("Legacy file: InvocationTargetException");
            return null;
        }
        catch (InstantiationException e) {
            Core.debugPrint("Legacy file: InstantiationException");
            return null;
        }
        return (ExtendedLibrary)loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtendedLibrary deserialize(String file) {
        FilterInputStream inputStream = null;
        try {
            inputStream = new DataInputStream(new FileInputStream(file));
            this.correlateBytes((DataInputStream)inputStream, classNameHeader);
            if (!((DataInputStream)inputStream).readUTF().equals("Library")) {
                ExtendedLibrary extendedLibrary = null;
                return extendedLibrary;
            }
            if (((DataInputStream)inputStream).readLong() != 5418843385105775949L) {
                ExtendedLibrary extendedLibrary = null;
                return extendedLibrary;
            }
            this.correlateBytes((DataInputStream)inputStream, libraryNameHeader);
            String libraryName = ((DataInputStream)inputStream).readUTF();
            this.correlateBytes((DataInputStream)inputStream, librarySizeHeader);
            long size = ((DataInputStream)inputStream).readLong();
            this.correlateBytes((DataInputStream)inputStream, capacityHeader);
            long capacity = ((DataInputStream)inputStream).readInt();
            if (capacity < size) {
                ExtendedLibrary extendedLibrary = null;
                return extendedLibrary;
            }
            this.correlateBytes((DataInputStream)inputStream, classHeader2);
            if (!((DataInputStream)inputStream).readUTF().equals("Patch")) {
                ExtendedLibrary extendedLibrary = null;
                return extendedLibrary;
            }
            if (((DataInputStream)inputStream).readLong() != 2569030717790349918L) {
                ExtendedLibrary extendedLibrary = null;
                return extendedLibrary;
            }
            ExtendedLibrary library2 = new ExtendedLibrary();
            library2.setName(libraryName);
            this.correlateBytes((DataInputStream)inputStream, firstPatchHeader);
            String tmpName = ((DataInputStream)inputStream).readUTF();
            this.correlateBytes((DataInputStream)inputStream, firstSysexHeader);
            byte[] tmpData = new byte[18];
            ((DataInputStream)inputStream).read(tmpData, 0, 18);
            library2.addPatch(new ExtendedPatch(tmpName, tmpData));
            int index = 1;
            while (this.correlateBytes((DataInputStream)inputStream, intermediatePatchHeader)) {
                tmpName = ((DataInputStream)inputStream).readUTF();
                this.correlateBytes((DataInputStream)inputStream, intermediateSysexHeader);
                tmpData = new byte[18];
                ((DataInputStream)inputStream).read(tmpData, 0, 18);
                library2.addPatch(new ExtendedPatch(tmpName, tmpData));
                ++index;
            }
            if ((long)index != size) {
                ExtendedLibrary extendedLibrary = null;
                return extendedLibrary;
            }
            ExtendedLibrary extendedLibrary = library2;
            return extendedLibrary;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private boolean correlateBytes(DataInputStream dis, byte[] bfr) throws IOException {
        int consumed = 0;
        int ptr = 0;
        while (dis.available() > 0 && ptr < bfr.length) {
            ++consumed;
            byte b = dis.readByte();
            if (b == bfr[ptr]) {
                ++ptr;
                continue;
            }
            ptr = 0;
        }
        return ptr == bfr.length && ptr == consumed;
    }
}

