/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.file;

import com.dd.plist.NSDictionary;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.bjno.j106.file.J106FileFilter;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;
import org.xml.sax.SAXException;

public class JepFileImportHandler
extends JFileChooser {
    J106FileFilter filtersyx;
    Core core;

    public JepFileImportHandler(Core c) {
        super("./");
        this.setMultiSelectionEnabled(true);
        this.filtersyx = new J106FileFilter();
        this.filtersyx.addExtension("jep");
        this.filtersyx.setDescription("Juno Editor Preset");
        this.setFileFilter(this.filtersyx);
        this.core = c;
    }

    public ExtendedLibrary importMultipleJepDialogue() {
        int returnVal = this.showOpenDialog(this.core.mainFrame);
        if (returnVal == 0) {
            File[] files = this.getSelectedFiles();
            ExtendedPatch p = null;
            ExtendedLibrary l = new ExtendedLibrary();
            for (int k = 0; k < files.length; ++k) {
                String tmp = files[k].getAbsolutePath();
                String localname = files[k].getName();
                if (localname.length() <= 4) continue;
                String originalName = localname;
                if (localname.substring(localname.length() - 4, localname.length()).equals(".jep")) {
                    localname = localname.substring(0, localname.length() - 4);
                }
                if ((p = this.importFromJepFile(tmp)) == null) {
                    JOptionPane.showMessageDialog(this.core.mainFrame, "Failure when importing file " + originalName + ". Aborting operation.");
                    return null;
                }
                p.setName(localname);
                l.addPatchClever(p);
            }
            return l;
        }
        return null;
    }

    private ExtendedPatch importFromJepFile(String filename) {
        byte[] data = null;
        try {
            NSDictionary dict = (NSDictionary)PropertyListParser.parse(filename);
            data = (byte[])dict.get("sysexData").toJavaObject();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (ParseException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        catch (PropertyListFormatException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        ExtendedPatch p = new ExtendedPatch("tmp", data);
        return p;
    }
}

