/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.file;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.bjno.j106.file.J106FileFilter;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.waves.J106Decoder;
import org.bjno.j106.waves.J106Encoder;

public class WavFileImportHandler
extends JFileChooser {
    J106FileFilter filtersyx;
    Core core;

    public WavFileImportHandler(Core c) {
        super("./");
        this.setMultiSelectionEnabled(false);
        this.filtersyx = new J106FileFilter();
        this.filtersyx.addExtension("wav");
        this.filtersyx.setDescription("Wav file");
        this.setFileFilter(this.filtersyx);
        this.core = c;
    }

    public ExtendedLibrary importWavDialogue() {
        int returnVal = this.showOpenDialog(this.core.mainFrame);
        if (returnVal == 0) {
            ExtendedLibrary l = this.readfile(this.getSelectedFile());
            if (l == null) {
                // empty if block
            }
            return l;
        }
        return null;
    }

    public void exportWavDialogue(ExtendedLibrary aLibrary) {
        int returnVal;
        boolean prioritizeTop = true;
        int option = 0;
        if (this.core.getLibrarySize() > 64) {
            JRadioButton firstRadioButton = new JRadioButton("Export the 64 first patches", true);
            JRadioButton secondRadioButton = new JRadioButton("Export the 64 last patches");
            ButtonGroup btngroup = new ButtonGroup();
            btngroup.add(firstRadioButton);
            btngroup.add(secondRadioButton);
            Object[] message = new Object[]{"A Juno-106 bank (A or B) can only contain 64 patches.\nThe current library contains " + this.core.getLibrarySize() + " patches.\n", firstRadioButton, secondRadioButton};
            option = JOptionPane.showConfirmDialog(this.core.mainFrame, message, "Export options", 2);
            if (secondRadioButton.isSelected()) {
                prioritizeTop = false;
            }
        } else if (this.core.getLibrarySize() < 64) {
            Object[] message = new Object[]{"A Juno-106 bank (A or B) must contain 64 patches.\nThe current library contains only " + this.core.getLibrarySize() + " patches.\nRemaining slots will be filled with \"Init\" patch data"};
            option = JOptionPane.showConfirmDialog(this.core.mainFrame, message, "Export options", 2);
        }
        if (option == 0 && (returnVal = this.showSaveDialog(this.core.mainFrame)) == 0) {
            String tmp = this.getSelectedFile().getAbsolutePath();
            if (!tmp.substring(tmp.length() - 4, tmp.length()).equals(".wav")) {
                tmp = tmp.concat(".wav");
                this.setSelectedFile(new File(this.getSelectedFile().getAbsolutePath() + ".wav"));
            }
            WavFileImportHandler.writefile(this.getSelectedFile(), aLibrary, prioritizeTop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writefile(File fileOut, ExtendedLibrary aLibrary, boolean prioritizeTop) {
        AudioFormat desiredFormat = new AudioFormat(44100.0f, 16, 1, true, true);
        J106Encoder encoder = new J106Encoder(false);
        Core.debugPrint("Save " + fileOut + " size: " + aLibrary.size() + " top: " + prioritizeTop);
        encoder.setLibrary(aLibrary, prioritizeTop);
        AudioFileFormat fileFormat = new AudioFileFormat(AudioFileFormat.Type.WAVE, desiredFormat, -1);
        AudioFileFormat.Type fileType = fileFormat.getType();
        J106Encoder.EncodingStream stream = encoder.getStream();
        try {
            Core.debugPrint(AudioSystem.write((AudioInputStream)stream, fileType, fileOut));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedLibrary readfile(File fileIn) {
        AudioFormat desiredFormat = new AudioFormat(44100.0f, 16, 1, true, true);
        J106Decoder decoder = new J106Decoder(null, false);
        decoder.initDecoderStates();
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(desiredFormat, AudioSystem.getAudioInputStream(fileIn));
            int bytesPerFrame = audioInputStream.getFormat().getFrameSize();
            if (bytesPerFrame == -1) {
                bytesPerFrame = 1;
            }
            int numBytes = 1024 * bytesPerFrame;
            byte[] audioBytes = new byte[numBytes];
            short[] sampleBuffer = new short[audioBytes.length / 2];
            int numberOfBytesRead = 0;
            while ((numberOfBytesRead = audioInputStream.read(audioBytes)) != -1) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(audioBytes));
                for (int i = 0; i < numberOfBytesRead / bytesPerFrame; ++i) {
                    sampleBuffer[i] = dis.readShort();
                }
                decoder.pushData(sampleBuffer, numberOfBytesRead / bytesPerFrame);
            }
        }
        catch (Exception e) {
            ExtendedLibrary numBytes = null;
            return numBytes;
        }
        finally {
            try {
                audioInputStream.close();
            }
            catch (IOException audioBytes) {}
        }
        if (decoder.state.equals((Object)J106Decoder.DecoderState.SUCCESSFUL_DECODING)) {
            JComboBox<String> bank = new JComboBox<String>();
            bank.addItem("A");
            bank.addItem("B");
            JTextField suffix = new JTextField();
            String name = this.getSelectedFile().getName();
            name = name.substring(0, name.length() - 4);
            suffix.setText(name);
            JComboBox<String> naming = new JComboBox<String>();
            naming.addItem("Start with location");
            naming.addItem("Start with name");
            Object[] message = new Object[]{"Bank location (A or B):", bank, "Bank name:", suffix, "Naming rule:", naming};
            int option = JOptionPane.showConfirmDialog(null, message, "Naming options", 2);
            if (option == 0) {
                return decoder.getReceivedLibrary((String)bank.getSelectedItem(), suffix.getText(), naming.getSelectedItem().equals("Start with location"));
            }
            return null;
        }
        JOptionPane.showMessageDialog(this.core.mainFrame, "Failure (" + (Object)((Object)decoder.state) + ") when importing tape data from " + this.getSelectedFile().getName() + ". Aborting operation.");
        return null;
    }
}

