/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Properties;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.swing.JOptionPane;
import org.bjno.j106.file.BinarySysexFileImportHandler;
import org.bjno.j106.file.FileHandler;
import org.bjno.j106.file.JepFileImportHandler;
import org.bjno.j106.file.LibrarySysexFileExportHandler;
import org.bjno.j106.file.WavFileImportHandler;
import org.bjno.j106.gui.AboutWindow;
import org.bjno.j106.gui.ImageHandler;
import org.bjno.j106.gui.JunoGui;
import org.bjno.j106.gui.MainFrame;
import org.bjno.j106.gui.MergeWindowLegacy;
import org.bjno.j106.gui.MidiKeyboard;
import org.bjno.j106.gui.OptionWindow;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;
import org.bjno.j106.midi.MidiTranslator;
import org.bjno.j7midi.MidiIn;
import org.bjno.j7midi.MidiOut;
import org.bjno.j7midi.MidiUser;

public class Core
implements MidiUser {
    private static final int SYSEX_MSG_TYPE_PROGRAM_CHANGE = 48;
    private static final int SYSEX_MSG_TYPE_MANUAL_MODE = 49;
    private static final int SYSEX_MSG_TYPE_CONTROL_CHANGE = 50;
    String version = "3.4.0";
    static boolean DEBUG;
    boolean inputDumpMode = false;
    boolean manualMode = false;
    private ExtendedPatch activePatch;
    private ExtendedLibrary activeLibrary;
    private ExtendedPatch receivedPatch;
    private ExtendedLibrary originalLibrary;
    public boolean thruRouting = false;
    private int midiChannel = 0;
    private MidiIn input;
    private MidiOut output;
    private MidiOut thru;
    public MidiKeyboard midiKeyboard;
    public AboutWindow aboutWindow;
    public OptionWindow optionWindow;
    public MergeWindowLegacy mergeWindow;
    public FileHandler fileHandler;
    public WavFileImportHandler wavFileImportHandler;
    public BinarySysexFileImportHandler binarySysexFileImportHandler;
    public JepFileImportHandler jepFileImportHandler;
    public LibrarySysexFileExportHandler librarySysexFileExportHandler;
    public MainFrame mainFrame;
    public JunoGui junoGui;
    private ImageHandler imageHandler;
    Hardware hardware;
    MidiTranslator midiTranslator;
    private String appDataPath = null;
    private boolean subFolder = true;
    private UndoStack undoStack = new UndoStack();
    static int[] log2;

    public Core(boolean debug) {
        DEBUG = debug;
        String os = System.getProperty("os.name");
        if (os.contains("Mac OS")) {
            Core.debugPrint("Detecting Mac: " + os);
            this.subFolder = true;
            this.appDataPath = System.getProperty("user.home") + "/Library/Application Support/";
        } else {
            Core.debugPrint("Detecting other OS: " + os);
            this.subFolder = false;
            this.appDataPath = System.getProperty("user.dir") + "/";
        }
        this.imageHandler = new ImageHandler();
        this.input = new MidiIn(this);
        this.output = new MidiOut();
        this.thru = new MidiOut();
        this.setHardware(Hardware.JUNO_106);
        this.fileHandler = new FileHandler(this);
        this.wavFileImportHandler = new WavFileImportHandler(this);
        this.binarySysexFileImportHandler = new BinarySysexFileImportHandler(this);
        this.librarySysexFileExportHandler = new LibrarySysexFileExportHandler(this);
        this.jepFileImportHandler = new JepFileImportHandler(this);
        this.midiKeyboard = new MidiKeyboard(this, 3);
        this.mainFrame = new MainFrame(this);
        this.mainFrame.setVisible(false);
        this.mainFrame.setResizable(false);
        this.junoGui = new JunoGui(this);
        this.junoGui.setVisible(true);
        this.mainFrame.getContentPane().add(this.junoGui);
        this.mainFrame.setUndecorated(false);
        this.mainFrame.pack();
        this.junoGui.setFocusable(true);
        this.mainFrame.addKeyListener(this.midiKeyboard.getKeyListener());
        this.mainFrame.setResizable(false);
        this.mainFrame.setLocationRelativeTo(null);
        this.optionWindow = new OptionWindow(this);
        this.aboutWindow = new AboutWindow(this);
        this.mergeWindow = new MergeWindowLegacy(this);
        ExtendedLibrary tmp = ExtendedLibrary.getInitLibrary();
        this.setLibrary(tmp);
        this.evaluateLibraryChanged();
        this.junoGui.view.setSelectedIndex(0);
        this.junoGui.view.updateContent();
        this.loadState();
        this.mainFrame.setVisible(true);
    }

    public void sendMidiMessage(MidiMessage m) {
        if (this.output.getPortName() != null) {
            this.output.send(m);
        }
    }

    @Override
    public void receiveMidiMessage(MidiMessage m) {
        if (m instanceof SysexMessage) {
            ExtendedPatch p;
            byte[] sysexData = ((SysexMessage)m).getData();
            if (sysexData[0] != 65) {
                return;
            }
            if (sysexData[2] != this.midiChannel) {
                return;
            }
            byte messageType = sysexData[1];
            if (messageType == 48 && !this.manualMode) {
                this.receivedPatch = this.patchFromMidiMessage(m);
                if (this.inputDumpMode) {
                    this.activeLibrary.addPatchClever(this.receivedPatch);
                    this.junoGui.view.updateContent();
                    this.junoGui.receivedPatchName.setText(this.receivedPatch.getName());
                    this.evaluateLibraryChanged();
                    Core.debugPrint("Patch " + this.receivedPatch.getName() + " saved.");
                } else {
                    this.junoGui.receivedPatchName.setText(this.receivedPatch.getName());
                    this.junoGui.receivedPatchName.setEnabled(true);
                    this.junoGui.button_input_save.setEnabled(true);
                    this.junoGui.button_input_ignore.setEnabled(true);
                    this.junoGui.indicator_received.setValue(true);
                }
            }
            if (messageType == 48 && this.manualMode) {
                JOptionPane.showMessageDialog(this.junoGui, "Selecting a patch on the Juno-106 while in manual mode makes the controllers not synchronized to the editor.\nPress the manual button on the synthesizer again for consistency.");
                p = this.patchFromMidiMessage(m);
                this.setActivePatch(p);
            }
            if (messageType == 49) {
                if (!this.manualMode) {
                    int opt = -1;
                    opt = this.hasPatchChanged() ? JOptionPane.showConfirmDialog(this.junoGui, "Entering external mode will synchronize the active patch with your Juno-106.\nDo you want to save the active patch before?", "External mode", 1) : JOptionPane.showConfirmDialog(this.junoGui, "Entering external mode will synchronize the active patch with your Juno-106.\nContinue?", "External mode", 2);
                    if (opt != 2) {
                        if (opt == 0) {
                            this.saveActivePatch();
                        }
                        ExtendedPatch p2 = this.patchFromMidiMessage(m);
                        this.enterManualMode(p2);
                    }
                } else {
                    p = this.patchFromMidiMessage(m);
                    p.setName("-----");
                    this.setActivePatch(p);
                }
            }
            if (messageType == 50 && this.manualMode) {
                this.activePatch.set(sysexData[4], (int)sysexData[3]);
                this.junoGui.setPatch(this.activePatch);
            }
        }
        if (this.thruRouting && m instanceof ShortMessage) {
            this.output.send(m);
        } else if (this.thru.getPortName() != null && m instanceof ShortMessage) {
            this.thru.send(m);
        }
    }

    private ExtendedPatch patchFromMidiMessage(MidiMessage mess) {
        int asciiOffset = 48;
        if (mess instanceof SysexMessage) {
            byte[] sysex = new byte[18];
            StringBuffer sbuf = new StringBuffer();
            byte[] sysexData = ((SysexMessage)mess).getData();
            for (int i = 0; i < 18; ++i) {
                sysex[i] = sysexData[i + 4];
            }
            int pnr = sysexData[3];
            if (pnr / 64 == 0) {
                sbuf.append("A");
            } else {
                sbuf.append("B");
            }
            sbuf.append((char)((pnr %= 64) / 8 + 1 + asciiOffset));
            sbuf.append((char)(pnr % 8 + 1 + asciiOffset));
            String name = new String(sbuf);
            return new ExtendedPatch(name, sysex);
        }
        return null;
    }

    public static byte[] patchToMidiSysex(ExtendedPatch p, int aMidiChannel) {
        byte[] fromPatch = p.getSysex();
        byte[] d = new byte[24];
        d[0] = -16;
        d[1] = 65;
        d[2] = 48;
        d[3] = (byte)aMidiChannel;
        d[4] = 0;
        for (int o = 0; o < 18; ++o) {
            d[o + 5] = fromPatch[o];
        }
        d[23] = -9;
        return d;
    }

    private MidiMessage patchToMidiMessage(ExtendedPatch p) {
        SysexMessage m = new SysexMessage();
        byte[] d = Core.patchToMidiSysex(p, this.midiChannel);
        try {
            m.setMessage(d, d.length);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        return m;
    }

    public void setMidiOutPort(String name) throws MidiUnavailableException {
        this.output.setPort(name);
    }

    public String getMidiOutPort() {
        return this.output.getPortName();
    }

    public void disableMidiOutPort() {
        this.output.reset();
    }

    public String[] getMidiOutPortNames() {
        return this.output.getAvailiblePorts();
    }

    public void setMidiInPort(String name) throws MidiUnavailableException {
        this.input.setPort(name);
    }

    public void disableMidiInPort() {
        this.input.reset();
    }

    public String[] getMidiInPortNames() {
        return this.input.getAvailiblePorts();
    }

    public void setMidiThruPort(String name) throws MidiUnavailableException {
        this.thru.setPort(name);
    }

    public String getMidiThruPort() {
        return this.thru.getPortName();
    }

    public void disableMidiThruPort() {
        this.thru.reset();
    }

    public void setMidiThruRouting(boolean b) {
        this.thruRouting = b;
    }

    public void setMidiChannel(int aMidiChannel) {
        this.midiChannel = aMidiChannel;
    }

    public int getMidiChannel() {
        return this.midiChannel;
    }

    private void setHardware(Hardware aHardware) {
        this.hardware = aHardware;
        if (this.hardware.equals((Object)Hardware.JU_06)) {
            this.midiTranslator = new MidiTranslator();
        }
    }

    protected Hardware getHardware() {
        return this.hardware;
    }

    private ExtendedPatch getActivePatch() {
        return this.activePatch;
    }

    public void setActivePatch(ExtendedPatch p) {
        this.activePatch = new ExtendedPatch(p);
        if (this.hardware.equals((Object)Hardware.JUNO_106)) {
            this.sendMidiMessage(this.patchToMidiMessage(p));
        } else {
            for (SysexMessage m : this.midiTranslator.patchToMidiMessages(p)) {
                this.sendMidiMessage(m);
            }
        }
        this.junoGui.setPatch(this.activePatch);
        this.undoStack.clear();
        this.pushUndo(JunoGui.ControllerId.k_controlUndefined);
        Core.debugPrint("Undo depth: " + this.undoStack.getDepth());
    }

    public void startCompare() {
        ExtendedPatch tmp = this.undoStack.getBottom().getPatch();
        Core.debugPrint(tmp);
        this.junoGui.setEditorEnabled(false);
        this.junoGui.setPatch(tmp);
        this.sendMidiMessage(this.patchToMidiMessage(tmp));
    }

    public void endCompare() {
        ExtendedPatch tmp = this.undoStack.peek().getPatch();
        Core.debugPrint(tmp);
        this.junoGui.setEditorEnabled(true);
        this.junoGui.setPatch(tmp);
        this.sendMidiMessage(this.patchToMidiMessage(tmp));
    }

    public void enterManualMode(ExtendedPatch p) {
        this.manualMode = true;
        p.setName(this.activeLibrary.getUniquePatchName("External"));
        this.undoStack.clear();
        this.setActivePatch(p);
        this.junoGui.setExternalMode();
        this.mainFrame.menuSystem.setEnabled(false);
        this.mainFrame.menuLibrary.setEnabled(false);
    }

    public void exitManualMode() {
        this.junoGui.indicator_manual.setValue(false);
        this.junoGui.setEnabled(true);
        this.setActivePatch(this.getActivePatch());
        this.mainFrame.menuSystem.setEnabled(true);
        this.mainFrame.menuLibrary.setEnabled(true);
    }

    private void updateActivePatch(ExtendedPatch p) {
        this.activePatch = new ExtendedPatch(p);
        if (this.hardware.equals((Object)Hardware.JUNO_106)) {
            this.sendMidiMessage(this.patchToMidiMessage(p));
        } else {
            for (SysexMessage m : this.midiTranslator.patchToMidiMessages(p)) {
                this.sendMidiMessage(m);
            }
        }
        this.junoGui.setPatch(this.activePatch);
    }

    public ExtendedPatch getReceivedPatch() {
        return this.receivedPatch;
    }

    public void setReceivedPatch(ExtendedPatch p) {
        this.receivedPatch = p;
    }

    public int[] compareToActiveLibrary(ExtendedLibrary aLibrary) {
        return ExtendedLibrary.qualitativeCompare(this.activeLibrary, aLibrary);
    }

    public void mergeToLibrary(ExtendedLibrary aLibrary, MergeDuplicateOption anOption) {
        switch (anOption.ordinal()) {
            case 0: {
                for (int i = 0; i < aLibrary.size(); ++i) {
                    this.activeLibrary.addPatch(aLibrary.getPatch(i));
                }
                break;
            }
            case 1: {
                for (int i = 0; i < aLibrary.size(); ++i) {
                    if (this.activeLibrary.getPatch(aLibrary.getPatch(i).getName()) != null) continue;
                    this.activeLibrary.addPatch(aLibrary.getPatch(i));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < aLibrary.size(); ++i) {
                    this.activeLibrary.addPatchClever(aLibrary.getPatch(i));
                }
                break;
            }
            case 3: {
                this.setLibrary(aLibrary);
                this.fileHandler.setTemporaryFilename(aLibrary.getName());
            }
        }
        this.triggerLibraryViewUpdate(-1);
        this.evaluateLibraryChanged();
    }

    public void setLibrary(ExtendedLibrary anActiveLibrary) {
        this.junoGui.libraryName.setText(this.fileHandler.getLocalFileName());
        this.setLibraryInternal(anActiveLibrary);
        this.originalLibrary = new ExtendedLibrary(this.activeLibrary);
    }

    private void setLibraryInternal(ExtendedLibrary anActiveLibrary) {
        this.activeLibrary = anActiveLibrary;
        this.junoGui.libraryName.setText(this.fileHandler.getLocalFileName());
        this.junoGui.setLibrary(anActiveLibrary, -1);
        this.setActivePatch(this.activeLibrary.getPatch(0));
    }

    public void setLibraryName(String s) {
        this.activeLibrary.setName(s);
        this.evaluateLibraryChanged();
    }

    public int getNrofUniquePatches() {
        return ExtendedLibrary.getNrofUnique(this.activeLibrary);
    }

    public void trimForDuplicates(int numDigits) {
        ExtendedLibrary result = ExtendedLibrary.trimForDuplicates(this.activeLibrary, numDigits);
        this.setLibraryInternal(result);
        this.evaluateLibraryChanged();
    }

    public String getLibraryName() {
        return this.activeLibrary.getName();
    }

    public ExtendedPatch getPatchAt(int anIndex) {
        return this.activeLibrary.getPatch(anIndex);
    }

    public boolean hasPatch(String aName) {
        return this.activeLibrary.getPatch(aName) != null;
    }

    public int getIndexOf(ExtendedPatch aPatch) {
        return this.activeLibrary.indexOf(aPatch);
    }

    public int getIndexOfActivePatch() {
        return this.activeLibrary.indexOf(this.activePatch);
    }

    public String getActivePatchName() {
        return this.activePatch.getName();
    }

    public void setActivePatchName(String aName) {
        this.activePatch.setName(aName);
        this.undoStack.rename(aName);
    }

    public void randomize() {
        this.activePatch.randomize();
        if (this.hardware.equals((Object)Hardware.JUNO_106)) {
            this.sendMidiMessage(this.patchToMidiMessage(this.activePatch));
        } else {
            for (SysexMessage m : this.midiTranslator.patchToMidiMessages(this.activePatch)) {
                this.sendMidiMessage(m);
            }
        }
        this.junoGui.setPatch(this.activePatch);
        this.pushUndo(JunoGui.ControllerId.k_controlUndefined);
        Core.debugPrint("Undo depth: " + this.undoStack.getDepth());
    }

    public void saveActivePatch() {
        int patchesInLibraryBefore = this.getLibrarySize();
        this.activeLibrary.addPatch(this.activePatch);
        if (patchesInLibraryBefore < this.getLibrarySize()) {
            this.junoGui.view.updateContent();
            if (this.getLibrarySize() == 1) {
                this.junoGui.view.setSelectedIndex(0);
            }
        }
        this.evaluateLibraryChanged();
        int undoDepthBefore = this.undoStack.getDepth();
        this.undoStack.clear();
        this.pushUndo(JunoGui.ControllerId.k_controlUndefined);
        Core.debugPrint("Undo depth: " + undoDepthBefore + "->" + this.undoStack.getDepth());
    }

    public int addPatchClever(ExtendedPatch aPatch) {
        int index = this.activeLibrary.addPatchClever(aPatch);
        this.evaluateLibraryChanged();
        return index;
    }

    public int addPatch(ExtendedPatch aPatch) {
        int index = this.activeLibrary.addPatch(aPatch);
        this.updatePatchHasChangesIndicator();
        this.evaluateLibraryChanged();
        return index;
    }

    public void removePatchAt(int anIndex) {
        this.activeLibrary.remove(anIndex);
        this.updatePatchHasChangesIndicator();
        this.evaluateLibraryChanged();
    }

    public boolean patchChangesDialogue() {
        if (this.hasPatchChanged()) {
            int opt = JOptionPane.showConfirmDialog(this.junoGui, "Active patch contains unsaved changes which will be lost. Save?", "Save option", 1);
            if (opt == 0) {
                this.saveActivePatch();
                return false;
            }
            if (opt == 2) {
                return true;
            }
        }
        return false;
    }

    public int fileStatusDialogue() {
        if (this.hasPatchChanged() && this.hasLibraryChanged()) {
            Object[] opts = new Object[]{"Save patch and library", "Save library", "Lose changes", "Cancel"};
            int opt = JOptionPane.showOptionDialog(this.mainFrame, "Both active patch and library contain unsaved changes. Save?", "Warning", -1, 3, null, opts, opts[0]);
            if (opt == 0) {
                this.saveActivePatch();
                this.saveLibrary();
                this.evaluateLibraryChanged();
            } else if (opt == 1) {
                this.saveLibrary();
            } else if (opt != 2 && (opt == 3 || opt == -1)) {
                return -1;
            }
        } else if (this.hasPatchChanged()) {
            Object[] opts = new Object[]{"Save Patch and Library", "Lose changes", "Cancel"};
            int opt = JOptionPane.showOptionDialog(this.mainFrame, "Current Patch contains unsaved changes. Save?", "Query", -1, 3, null, opts, opts[0]);
            if (opt == 0) {
                this.saveActivePatch();
                this.saveLibrary();
            } else if (opt != 1 && (opt == 2 || opt == -1)) {
                return -1;
            }
        } else if (this.hasLibraryChanged()) {
            Object[] opts = new Object[]{"Save Library", "Lose changes", "Cancel"};
            int opt = JOptionPane.showOptionDialog(this.mainFrame, "Current Library contains unsaved changes. Save?", "Query", -1, 3, null, opts, opts[0]);
            if (opt == 2 || opt == -1) {
                return -1;
            }
            if (opt == 0) {
                this.saveLibrary();
            }
            if (opt == 1) {
                // empty if block
            }
        }
        return 1;
    }

    public void initNewLibrary() {
        int status = this.fileStatusDialogue();
        if (status != -1) {
            ExtendedLibrary tmp = ExtendedLibrary.getInitLibrary();
            this.setLibrary(tmp);
            this.setActivePatch(tmp.getPatch(0));
            this.junoGui.view.setSelectedIndex(0);
            this.junoGui.view.updateContent();
            this.fileHandler.setDefault();
            this.fileHandler.setTemporaryFilename(this.activeLibrary.getName());
            this.evaluateLibraryChanged();
        }
    }

    public void loadLibraryDialogue() {
        int status = this.fileStatusDialogue();
        if (status != -1) {
            ExtendedLibrary libr = null;
            libr = this.fileHandler.loadLibraryDialogue();
            if (libr != null) {
                this.setLibrary(libr);
                this.evaluateLibraryChanged();
                if (libr.size() != 0) {
                    this.setActivePatch(libr.getPatch(0));
                    this.junoGui.view.setSelectedIndex(0);
                    this.junoGui.view.updateContent();
                }
            }
        }
    }

    public void saveLibraryDialogue() {
        boolean saved = this.fileHandler.saveLibraryDialogue(this.activeLibrary);
        if (saved) {
            this.originalLibrary = new ExtendedLibrary(this.activeLibrary);
            this.evaluateLibraryChanged();
        }
    }

    public void saveLibrary() {
        boolean saved = this.fileHandler.saveLibrary(this.activeLibrary);
        if (saved) {
            this.originalLibrary = new ExtendedLibrary(this.activeLibrary);
            this.evaluateLibraryChanged();
        }
    }

    public void exportLibraryToWav() {
        this.wavFileImportHandler.exportWavDialogue(this.activeLibrary);
    }

    public void exportPatchToSysex() {
        this.binarySysexFileImportHandler.exportDialogue(this.activePatch);
    }

    public void exportLibraryToSysex() {
        this.librarySysexFileExportHandler.exportDialogue(this.activeLibrary);
    }

    public static void debugPrint(Object o) {
        if (DEBUG) {
            System.out.println(o);
        }
    }

    public void saveState() {
        String folderPath;
        Properties p = new Properties();
        p.setProperty("MIDI IN", (String)this.optionWindow.midiin.getSelectedItem());
        p.setProperty("MIDI OUT", (String)this.optionWindow.midiout.getSelectedItem());
        if (this.optionWindow.midithrurouting.isSelected()) {
            p.setProperty("MIDI THRU", "_ROUTE");
        } else {
            p.setProperty("MIDI THRU", (String)this.optionWindow.midithru.getSelectedItem());
        }
        p.setProperty("KEYBOARD OCTAVE", Integer.toString(this.midiKeyboard.getOctave()));
        p.setProperty("KEYBOARD KEYS", Boolean.toString(this.junoGui.indicator_kybd.getValue()));
        p.setProperty("KEYBOARD MOUSE", Boolean.toString(this.junoGui.indicator_mouse.getValue()));
        p.setProperty("MIDI CHANNEL", Integer.toString(this.midiChannel));
        p.setProperty("SCALE", Integer.toString((int)(100.0 * this.junoGui.getScale())));
        p.setProperty("FILE PATH", this.fileHandler.getCurrentDirectory().getAbsolutePath());
        boolean directoryExists = false;
        if (this.subFolder) {
            folderPath = this.appDataPath + "org/bjno/";
            if (new File(folderPath).exists()) {
                Core.debugPrint("Dir existed: " + folderPath);
                directoryExists = true;
            } else {
                Core.debugPrint("Dir created: " + folderPath);
                directoryExists = new File(folderPath).mkdirs();
            }
        } else {
            folderPath = this.appDataPath;
            directoryExists = true;
        }
        if (directoryExists && Files.isWritable(new File(folderPath).toPath())) {
            String configFilePath = folderPath + "properties.cfg";
            try {
                Core.debugPrint("State: " + p.toString());
                p.store(new FileOutputStream(configFilePath), this.version);
                Core.debugPrint("File saved: " + configFilePath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Core.debugPrint("Directory did not exist, and could not be created");
        }
    }

    public void loadState() {
        int channel;
        String path = this.appDataPath;
        String configFilePath = this.subFolder ? path + "org/bjno/properties.cfg" : path + "properties.cfg";
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(configFilePath));
            Core.debugPrint("Successfully read config file at: " + configFilePath);
        }
        catch (FileNotFoundException e1) {
            Core.debugPrint("Config file not found at: " + configFilePath);
        }
        catch (IOException e1) {
            Core.debugPrint("IO exception when reading config file at: " + configFilePath);
        }
        if (p.isEmpty()) {
            Core.debugPrint("Configuration state could not be loaded");
            return;
        }
        Core.debugPrint("Loaded state: " + p.toString());
        int midiPortsUnavailable = 0;
        String value = p.getProperty("FILE PATH");
        if (value != null) {
            File tmp = new File(value);
            if (tmp.exists()) {
                this.fileHandler.setCurrentDirectory(new File(value));
                Core.debugPrint("Set path " + value);
            } else {
                Core.debugPrint("Path does not exist " + value);
            }
        }
        if ((value = p.getProperty("MIDI IN")) != null) {
            try {
                this.setMidiInPort(value);
                this.optionWindow.midiin.setSelectedItem(value);
            }
            catch (MidiUnavailableException e) {
                Core.debugPrint("Could not set MIDI in to:" + value);
                ++midiPortsUnavailable;
            }
        }
        if ((value = p.getProperty("MIDI OUT")) != null) {
            try {
                this.setMidiOutPort(value);
                this.optionWindow.midiout.setSelectedItem(value);
            }
            catch (MidiUnavailableException e) {
                Core.debugPrint("Could not set MIDI out to:" + value);
                ++midiPortsUnavailable;
            }
        }
        if ((value = p.getProperty("MIDI THRU")) != null) {
            if (value.equals("_ROUTE")) {
                this.optionWindow.midithru.setEnabled(false);
                this.optionWindow.midithrurouting.setSelected(true);
                this.disableMidiThruPort();
                this.setMidiThruRouting(true);
            } else {
                try {
                    this.setMidiThruPort(value);
                    this.optionWindow.midithru.setSelectedItem(value);
                }
                catch (MidiUnavailableException e) {
                    Core.debugPrint("Could not set MIDI thru to:" + value);
                    ++midiPortsUnavailable;
                }
            }
        }
        if ((value = p.getProperty("KEYBOARD OCTAVE")) != null) {
            this.midiKeyboard.setOctave(Integer.valueOf(value));
        }
        if (!this.midiKeyboard.canDecreaseOctave()) {
            this.junoGui.button_keyboard_down.setEnabled(false);
        } else if (!this.midiKeyboard.canIncreaseOctave()) {
            this.junoGui.button_keyboard_up.setEnabled(false);
        }
        value = p.getProperty("KEYBOARD KEYS");
        if (value != null) {
            boolean b = Boolean.valueOf(value);
            this.midiKeyboard.setAbcEnabled(b);
            this.junoGui.indicator_kybd.setValue(b);
        }
        if ((value = p.getProperty("KEYBOARD MOUSE")) != null) {
            boolean b = Boolean.valueOf(value);
            this.midiKeyboard.setMouseEnabled(b);
            this.junoGui.indicator_mouse.setValue(b);
        }
        if ((value = p.getProperty("MIDI CHANNEL")) != null && (channel = Integer.valueOf(value).intValue()) > 0 && channel < 16) {
            this.midiChannel = channel;
            this.optionWindow.midiChannel.setSelectedItem(channel + 1);
        }
        if ((value = p.getProperty("SCALE")) != null) {
            double fScale = (double)Integer.valueOf(value).intValue() / 100.0;
            this.setScale(fScale, true);
            this.mainFrame.setScale(fScale);
        }
        if (midiPortsUnavailable > 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "There were problems to set one or more of the MIDI ports used in the last session.", "MIDI unavailible exception", 0);
        }
    }

    private void evaluateLibraryChanged() {
        if (this.hasLibraryChanged()) {
            this.mainFrame.setSaveEnabled(true);
            this.junoGui.libraryName.setText(">" + this.fileHandler.getLocalFileName());
        } else {
            this.junoGui.libraryName.setText(this.fileHandler.getLocalFileName());
            this.mainFrame.setSaveEnabled(false);
        }
    }

    public void safeExit() {
        int status = this.fileStatusDialogue();
        if (status != -1) {
            this.saveState();
            this.input.reset();
            this.output.reset();
            this.thru.reset();
            System.exit(0);
        }
    }

    public boolean hasPatchChanged() {
        return this.undoStack.hasChanges() || this.activeLibrary.getPatch(this.activePatch.getName()) == null;
    }

    public int getLibrarySize() {
        return this.activeLibrary.size();
    }

    public void triggerLibraryViewUpdate(int aVisibleIndex) {
        this.junoGui.setLibrary(this.activeLibrary, aVisibleIndex);
    }

    public boolean hasLibraryChanged() {
        return !ExtendedLibrary.equals(this.originalLibrary, this.activeLibrary);
    }

    public boolean isLibraryInit() {
        return this.activeLibrary.isInitLibrary();
    }

    private void updatePatchHasChangesIndicator() {
        boolean patchChanged = this.hasPatchChanged();
        this.junoGui.indicator_patchsave.setValue(patchChanged);
        this.junoGui.button_patch_save.setEnabled(patchChanged);
    }

    public void undo() {
        this.updateActivePatch(this.undoStack.undo().getPatch());
        this.updatePatchHasChangesIndicator();
        this.junoGui.button_patch_undo.setEnabled(this.undoStack.hasUndoData());
        this.junoGui.button_patch_compare.setEnabled(this.undoStack.hasUndoData());
    }

    public void pushUndo(JunoGui.ControllerId controllerId) {
        this.undoStack.push(this.activePatch, controllerId);
        this.updatePatchHasChangesIndicator();
        this.junoGui.button_patch_undo.setEnabled(this.undoStack.hasUndoData());
        this.junoGui.button_patch_compare.setEnabled(this.undoStack.hasUndoData());
    }

    public boolean hasUndoData() {
        return this.undoStack.hasUndoData();
    }

    public Image getImage(String aName) {
        return this.imageHandler.getImage(aName);
    }

    public String getVersion() {
        return this.version;
    }

    public void controlChange(JunoGui.ControllerId aControllerId, int aValue) {
        int ju06value = -1;
        int ju06control = -1;
        double multiplier = 2.015748;
        switch (aControllerId) {
            case k_button_range: {
                this.getActivePatch().setrange(aValue);
                ju06control = 1792;
                ju06value = 4 - log2[aValue];
                break;
            }
            case k_button_square: {
                this.getActivePatch().setpulse(aValue == 1);
                ju06control = 1800;
                ju06value = aValue;
                break;
            }
            case k_button_saw: {
                this.getActivePatch().setsaw(aValue == 1);
                ju06control = 1802;
                ju06value = aValue;
                break;
            }
            case k_button_chorus: {
                this.getActivePatch().setchorus(aValue);
                ju06control = 4096;
                ju06value = aValue;
                break;
            }
            case k_switchEnvMode: {
                if (aValue == 0) {
                    this.getActivePatch().setENV("-");
                } else {
                    this.getActivePatch().setENV("+");
                }
                ju06control = 2054;
                ju06value = aValue;
                break;
            }
            case k_switchPwmSource: {
                if (aValue == 0) {
                    this.getActivePatch().setPWM("MAN");
                } else {
                    this.getActivePatch().setPWM("LFO");
                }
                ju06control = 1798;
                ju06value = aValue;
                break;
            }
            case k_switchVcaMode: {
                if (aValue == 0) {
                    this.getActivePatch().setVCA("gate");
                } else {
                    this.getActivePatch().setVCA("ENV");
                }
                ju06control = 2304;
                ju06value = aValue;
                break;
            }
            case k_sliderHPfilter: {
                this.getActivePatch().setHPfilter(aValue);
                ju06control = 2048;
                ju06value = aValue * 85;
                break;
            }
            case k_sliderDCOLFO: {
                this.getActivePatch().setDCOLFO(aValue);
                ju06control = 1794;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderDCOPWM: {
                this.getActivePatch().setDCOPWM(aValue);
                ju06control = 1796;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderLFOdelay: {
                this.getActivePatch().setLFOdelay(aValue);
                ju06control = 1538;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderLfoRate: {
                this.getActivePatch().setLFOrate(aValue);
                ju06control = 1536;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderVCAlevel: {
                this.getActivePatch().setVCAlevel(aValue);
                ju06control = 2306;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderVCFENV: {
                this.getActivePatch().setVCFENV(aValue);
                ju06control = 2056;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderVCFKYBD: {
                this.getActivePatch().setVCFKYBD(aValue);
                ju06control = 2060;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderVCFLFO: {
                this.getActivePatch().setVCFLFO(aValue);
                ju06control = 2058;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderVCFcutoff: {
                this.getActivePatch().setVCFcutoff(aValue);
                ju06control = 2050;
                double tmpVal = 1.239 * (double)aValue - 4.57;
                if (tmpVal > 127.0) {
                    tmpVal = 127.0;
                } else if (tmpVal < 0.0) {
                    tmpVal = 0.0;
                }
                ju06value = (int)(multiplier * tmpVal);
                break;
            }
            case k_sliderattack: {
                this.getActivePatch().setattack(aValue);
                ju06control = 2560;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderdecay: {
                this.getActivePatch().setdecay(aValue);
                ju06control = 2562;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_slidernoiselevel: {
                this.getActivePatch().setnoiselevel(aValue);
                ju06control = 1806;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderrelease: {
                this.getActivePatch().setrelease(aValue);
                ju06control = 2566;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_sliderresonance: {
                this.getActivePatch().setresonance(aValue);
                ju06control = 2052;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_slidersublevel: {
                this.getActivePatch().setsublevel(aValue);
                ju06control = 1804;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_slidersustain: {
                this.getActivePatch().setsustain(aValue);
                ju06control = 2564;
                ju06value = (int)(multiplier * (double)aValue);
                break;
            }
            case k_controlUndefined: {
                Core.debugPrint("Suspicous k_controlUndefined");
                break;
            }
        }
        if (this.hardware.equals((Object)Hardware.JUNO_106)) {
            this.sendMidiMessage(this.patchToMidiMessage(this.getActivePatch()));
        } else {
            this.sendMidiMessage(this.midiTranslator.controlToMidiMessage(ju06control, ju06value));
        }
        this.pushUndo(aControllerId);
    }

    public void setScale(double aScale, boolean scaleGui) {
        this.junoGui.setScale(aScale, scaleGui);
        this.mainFrame.pack();
    }

    static {
        log2 = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4};
    }

    public class UndoStack {
        long minDelta = 1000L;
        ArrayList<UndoState> stack = new ArrayList();

        public void push(ExtendedPatch patch, JunoGui.ControllerId aControllerId) {
            if (this.stack.size() > 0 && this.peek().getComponentId() == aControllerId && this.peek().getAge() < this.minDelta) {
                this.stack.remove(this.stack.size() - 1);
            }
            this.stack.add(new UndoState(new ExtendedPatch(patch), aControllerId));
        }

        public boolean hasChanges() {
            return !this.stack.get(0).getPatch().deepEquals(this.peek().getPatch());
        }

        public boolean hasUndoData() {
            return this.stack.size() > 1;
        }

        public UndoState peek() {
            return this.stack.get(this.stack.size() - 1);
        }

        public UndoState getBottom() {
            return this.stack.get(0);
        }

        public int getDepth() {
            return this.stack.size();
        }

        public UndoState undo() {
            this.stack.remove(this.stack.size() - 1);
            return this.peek();
        }

        public void rename(String aName) {
            for (UndoState s : this.stack) {
                s.getPatch().setName(aName);
            }
        }

        public void clear() {
            this.stack.clear();
        }
    }

    public static enum Hardware {
        JUNO_106,
        JU_06;

    }

    public class UndoState {
        private long timeStamp;
        private ExtendedPatch patch;
        private JunoGui.ControllerId controllerId;

        public UndoState(ExtendedPatch aPatch, JunoGui.ControllerId aControllerId) {
            this.patch = aPatch;
            this.controllerId = aControllerId;
            this.timeStamp = System.currentTimeMillis();
        }

        public ExtendedPatch getPatch() {
            return this.patch;
        }

        public JunoGui.ControllerId getComponentId() {
            return this.controllerId;
        }

        public long getAge() {
            return System.currentTimeMillis() - this.timeStamp;
        }

        public String toString() {
            return this.getAge() + " " + this.patch.toString();
        }
    }

    public static enum MergeDuplicateOption {
        OVERWRITE,
        DISCARD,
        SMART,
        INIT_FROM_IMPORTED_LIBRARY;

    }
}

