/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.TreeMap;
import javax.swing.JFrame;
import org.bjno.j106.gui.Core;

public class ImageHandler {
    String[] imageFiles = new String[]{"bg_2.png", "bg_hires_layer.png", "button_blue.png", "button_blue_active.png", "button_grey.png", "button_grey_active.png", "button_orange.png", "button_orange_active.png", "light_off.png", "light_on.png", "listview.png", "menu.png", "midi.png", "midimon.png", "pbend_handle.png", "slider_handle.png", "small_button_grey.png", "small_button_grey_active.png", "small_button_orange.png", "small_button_orange_active.png", "splash.png", "switch_handle.png", "library_slider.png", "library_button_up.png", "library_button_down.png"};
    TreeMap<String, Image> images;
    MediaTracker mt;

    public ImageHandler() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.images = new TreeMap();
        MediaTracker mt = new MediaTracker(new JFrame());
        int mtIndex = 0;
        for (String filename : this.imageFiles) {
            Image tmp = tk.getImage(this.getClass().getResource("/gui/" + filename));
            this.images.put(filename, tmp);
            mt.addImage(tmp, mtIndex);
            ++mtIndex;
        }
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (mt.isErrorAny()) {
            Object[] err = mt.getErrorsAny();
            for (int y = 0; y < err.length; ++y) {
                Core.debugPrint(((Image)err[y]).toString());
            }
        }
    }

    public Image getImage(String name) {
        if (this.images.containsKey(name)) {
            return this.images.get(name);
        }
        Core.debugPrint("Image not found: " + name);
        return null;
    }
}

