/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.bjno.j106.gui.Core;
import org.bjno.j106.gui.FocusTracer;
import org.bjno.j106.gui.LibraryView;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;
import org.bjno.jcustomgui.JCustomButton;
import org.bjno.jcustomgui.JCustomEvent;
import org.bjno.jcustomgui.JCustomIndicator;
import org.bjno.jcustomgui.JCustomListener;
import org.bjno.jcustomgui.JCustomPanel;
import org.bjno.jcustomgui.JCustomSlider;

public class JunoGui
extends JCustomPanel {
    Core core;
    LibraryView view;
    JCustomIndicator range16;
    JCustomIndicator range8;
    JCustomIndicator range4;
    JCustomIndicator square;
    JCustomIndicator saw;
    JCustomIndicator chorusI;
    JCustomIndicator chorusII;
    JCustomButton button_range_16;
    JCustomButton button_range_8;
    JCustomButton button_range_4;
    JCustomButton button_square;
    JCustomButton button_saw;
    JCustomButton button_chorus_OFF;
    JCustomButton button_chorus_I;
    JCustomButton button_chorus_II;
    JCustomSlider sliderLfoRate;
    JCustomSlider sliderLFOdelay;
    JCustomSlider sliderDCOLFO;
    JCustomSlider sliderDCOPWM;
    JCustomSlider slidersublevel;
    JCustomSlider slidernoiselevel;
    JCustomSlider sliderVCFcutoff;
    JCustomSlider sliderresonance;
    JCustomSlider sliderVCFENV;
    JCustomSlider sliderVCFLFO;
    JCustomSlider sliderVCFKYBD;
    JCustomSlider sliderVCAlevel;
    JCustomSlider sliderattack;
    JCustomSlider sliderdecay;
    JCustomSlider slidersustain;
    JCustomSlider sliderrelease;
    JCustomSlider sliderHPfilter;
    JCustomSlider sliderPitch;
    JCustomSlider sliderMod;
    JCustomSlider switchPwmSource;
    JCustomSlider switchEnvMode;
    JCustomSlider switchVcaMode;
    JCustomButton button_patch_new;
    JCustomButton button_patch_save;
    JCustomButton button_patch_name;
    JCustomButton button_patch_duplicate;
    JCustomButton button_patch_erase;
    JCustomButton button_patch_edit;
    JCustomButton button_input_save;
    JCustomButton button_input_ignore;
    JCustomButton button_keyboard_up;
    JCustomButton button_keyboard_down;
    JCustomButton button_keyboard_mouse;
    JCustomButton button_keyboard_kybd;
    JCustomButton button_keyboard_panic;
    JCustomButton button_input_dump;
    JCustomButton button_patch_undo;
    JCustomButton button_patch_compare;
    JCustomButton button_patch_random;
    JCustomIndicator indicator_patchsave;
    JCustomIndicator indicator_dump;
    JCustomIndicator indicator_manual;
    JCustomIndicator indicator_received;
    JCustomIndicator indicator_kybd;
    JCustomIndicator indicator_mouse;
    private double scale = 1.0;
    private int fontSize100 = 11;
    private int fontSize125 = 13;
    private int fontSize150 = 17;
    private int fontSize200 = 20;
    JTextField receivedPatchName;
    JLabel patchName;
    JLabel libraryName;
    JLabel controlValue;
    int yOffsetEditor = 39;
    GuiListener g = new GuiListener();
    FocusTracer cf;
    Timer randomizeTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JunoGui.this.core.randomize();
        }
    });

    public JunoGui(Core aCore) {
        super(910, 600);
        this.setVisible(false);
        this.core = aCore;
        Font f = new Font("Monospaced", 1, this.fontSize100);
        this.receivedPatchName = new JTextField("");
        this.receivedPatchName.setText("-------");
        this.receivedPatchName.setEnabled(false);
        this.receivedPatchName.setFont(f);
        this.receivedPatchName.setOpaque(false);
        this.receivedPatchName.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.receivedPatchName.setForeground(new Color(204, 0, 17));
        this.receivedPatchName.setDisabledTextColor(new Color(100, 0, 17));
        this.receivedPatchName.setSelectionColor(new Color(204, 0, 17));
        this.receivedPatchName.setSelectedTextColor(new Color(0, 0, 0));
        this.add(this.receivedPatchName, 12, 377 + this.yOffsetEditor, 104, 16);
        Image btnGreyNormal = this.core.getImage("button_grey.png");
        Image btnGreyActive = this.core.getImage("button_grey_active.png");
        Image btnOrangeNormal = this.core.getImage("button_orange.png");
        Image btnOrangeActive = this.core.getImage("button_orange_active.png");
        Image btnBlueNormal = this.core.getImage("button_blue.png");
        Image btnBlueActive = this.core.getImage("button_blue_active.png");
        Image sBtnOrangeNormal = this.core.getImage("small_button_orange.png");
        Image sBtnOrangeActive = this.core.getImage("small_button_orange_active.png");
        Image sBtnGreyNormal = this.core.getImage("small_button_grey.png");
        Image sBtnGreyActive = this.core.getImage("small_button_grey_active.png");
        Image sliderHandleNormal = this.core.getImage("slider_handle.png");
        Image switchHandleNormal = this.core.getImage("switch_handle.png");
        Image midi = this.core.getImage("midi.png");
        Image pitchBendHandle = this.core.getImage("pbend_handle.png");
        Image indicatorOn = this.core.getImage("light_on.png");
        Image indicatorOff = this.core.getImage("light_off.png");
        this.setBackground(this.core.getImage("bg_2.png"));
        this.setOverlay(this.core.getImage("bg_hires_layer.png"));
        this.core.midiKeyboard.setBackground(midi);
        this.add((Component)this.core.midiKeyboard, 280, 381 + this.yOffsetEditor);
        this.view = new LibraryView(this.core.getImage("listview.png"), this.core.getImage("library_slider.png"), this.core.getImage("library_button_up.png"), this.core.getImage("library_button_down.png"), 172, 248, 16, 16, this.fontSize100);
        this.add((Component)this.view, 8, 105);
        this.sliderPitch = new JCustomSlider(ComponentId.k_sliderPitch, pitchBendHandle, 12, 56, 12, 12, 0, 127, false);
        this.sliderPitch.setElastic(true, 63);
        this.sliderPitch.setKeyEnabled(false);
        this.sliderPitch.setMouseWheelEnabled(false);
        this.sliderPitch.setValue(63);
        this.sliderMod = new JCustomSlider(ComponentId.k_sliderMod, pitchBendHandle, 12, 56, 12, 12, 0, 127, false);
        this.sliderMod.setElastic(true, 0);
        this.sliderMod.setKeyEnabled(false);
        this.sliderMod.setMouseWheelEnabled(false);
        this.add((Component)this.sliderMod, 252, 381 + this.yOffsetEditor);
        this.add((Component)this.sliderPitch, 220, 381 + this.yOffsetEditor);
        this.sliderLfoRate = new JCustomSlider(ComponentId.k_sliderLfoRate, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderLFOdelay = new JCustomSlider(ComponentId.k_sliderLFOdelay, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderDCOLFO = new JCustomSlider(ComponentId.k_sliderDCOLFO, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderDCOPWM = new JCustomSlider(ComponentId.k_sliderDCOPWM, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.slidersublevel = new JCustomSlider(ComponentId.k_slidersublevel, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.slidernoiselevel = new JCustomSlider(ComponentId.k_slidernoiselevel, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderHPfilter = new JCustomSlider(ComponentId.k_sliderHPfilter, sliderHandleNormal, 24, 96, 24, 16, 0, 3, true);
        this.sliderVCFcutoff = new JCustomSlider(ComponentId.k_sliderVCFcutoff, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderresonance = new JCustomSlider(ComponentId.k_sliderresonance, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderVCFENV = new JCustomSlider(ComponentId.k_sliderVCFENV, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderVCFLFO = new JCustomSlider(ComponentId.k_sliderVCFLFO, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderVCFKYBD = new JCustomSlider(ComponentId.k_sliderVCFKYBD, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderVCAlevel = new JCustomSlider(ComponentId.k_sliderVCAlevel, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderattack = new JCustomSlider(ComponentId.k_sliderattack, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderdecay = new JCustomSlider(ComponentId.k_sliderdecay, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.slidersustain = new JCustomSlider(ComponentId.k_slidersustain, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.sliderrelease = new JCustomSlider(ComponentId.k_sliderrelease, sliderHandleNormal, 24, 96, 24, 16, 0, 127, false);
        this.switchPwmSource = new JCustomSlider(ComponentId.k_switchPwmSource, switchHandleNormal, 16, 32, 16, 16, 0, 1, true);
        this.switchEnvMode = new JCustomSlider(ComponentId.k_switchEnvMode, switchHandleNormal, 16, 32, 16, 16, 0, 1, true);
        this.switchVcaMode = new JCustomSlider(ComponentId.k_switchVcaMode, switchHandleNormal, 16, 32, 16, 16, 0, 1, true);
        this.add((Component)this.sliderLfoRate, 208, 53 + this.yOffsetEditor);
        this.add((Component)this.sliderLFOdelay, 236, 53 + this.yOffsetEditor);
        this.add((Component)this.sliderDCOLFO, 408, 53 + this.yOffsetEditor);
        this.add((Component)this.sliderDCOPWM, 436, 53 + this.yOffsetEditor);
        this.add((Component)this.slidersublevel, 596, 53 + this.yOffsetEditor);
        this.add((Component)this.slidernoiselevel, 624, 53 + this.yOffsetEditor);
        this.add((Component)this.sliderHPfilter, 688, 53 + this.yOffsetEditor);
        this.add((Component)this.sliderVCFcutoff, 204, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderresonance, 232, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderVCFENV, 312, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderVCFLFO, 340, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderVCFKYBD, 368, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderVCAlevel, 456, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderattack, 508, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderdecay, 536, 213 + this.yOffsetEditor);
        this.add((Component)this.slidersustain, 564, 213 + this.yOffsetEditor);
        this.add((Component)this.sliderrelease, 592, 213 + this.yOffsetEditor);
        this.add((Component)this.switchPwmSource, 480, 85 + this.yOffsetEditor);
        this.add((Component)this.switchEnvMode, 276, 245 + this.yOffsetEditor);
        this.add((Component)this.switchVcaMode, 420, 245 + this.yOffsetEditor);
        this.button_range_16 = new JCustomButton(ComponentId.k_button_range_16, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_range_8 = new JCustomButton(ComponentId.k_button_range_8, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_range_4 = new JCustomButton(ComponentId.k_button_range_4, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_square = new JCustomButton(ComponentId.k_button_square, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_saw = new JCustomButton(ComponentId.k_button_saw, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_chorus_OFF = new JCustomButton(ComponentId.k_button_chorus_OFF, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_chorus_I = new JCustomButton(ComponentId.k_button_chorus_I, btnOrangeNormal, btnOrangeActive, 28, 20);
        this.button_chorus_II = new JCustomButton(ComponentId.k_button_chorus_II, btnOrangeNormal, btnOrangeActive, 28, 20);
        this.button_patch_new = new JCustomButton(ComponentId.k_button_patch_new, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_patch_save = new JCustomButton(ComponentId.k_button_patch_save, sBtnOrangeNormal, sBtnOrangeActive, 20, 16);
        this.button_patch_undo = new JCustomButton(ComponentId.k_button_patch_undo, sBtnGreyNormal, sBtnGreyActive, 20, 16);
        this.button_patch_compare = new JCustomButton(ComponentId.k_button_patch_compare, sBtnGreyNormal, sBtnGreyActive, 20, 16);
        this.button_patch_random = new JCustomButton(ComponentId.k_button_patch_random, sBtnGreyNormal, sBtnGreyActive, 20, 16);
        this.button_patch_name = new JCustomButton(ComponentId.k_button_patch_name, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_patch_duplicate = new JCustomButton(ComponentId.k_button_patch_duplicate, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_patch_erase = new JCustomButton(ComponentId.k_button_patch_erase, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_patch_edit = new JCustomButton(ComponentId.k_button_patch_edit, btnBlueNormal, btnBlueActive, 28, 20);
        this.button_input_save = new JCustomButton(ComponentId.k_button_input_save, sBtnOrangeNormal, sBtnOrangeActive, 20, 16);
        this.button_input_ignore = new JCustomButton(ComponentId.k_button_input_ignore, sBtnGreyNormal, sBtnGreyActive, 20, 16);
        this.button_input_dump = new JCustomButton(ComponentId.k_button_input_dump, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_keyboard_up = new JCustomButton(ComponentId.k_button_keyboard_up, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_keyboard_down = new JCustomButton(ComponentId.k_button_keyboard_down, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_keyboard_mouse = new JCustomButton(ComponentId.k_button_keyboard_mouse, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_keyboard_kybd = new JCustomButton(ComponentId.k_button_keyboard_kybd, btnGreyNormal, btnGreyActive, 28, 20);
        this.button_keyboard_panic = new JCustomButton(ComponentId.k_button_keyboard_panic, btnBlueNormal, btnBlueActive, 28, 20);
        this.add((Component)this.button_patch_save, 396, 20);
        this.add((Component)this.button_patch_undo, 440, 20);
        this.add((Component)this.button_patch_compare, 484, 20);
        this.add((Component)this.button_patch_random, 548, 20);
        this.add((Component)this.button_patch_edit, 8, 41 + this.yOffsetEditor);
        this.add((Component)this.button_patch_new, 44, 41 + this.yOffsetEditor);
        this.add((Component)this.button_patch_name, 80, 41 + this.yOffsetEditor);
        this.add((Component)this.button_patch_duplicate, 116, 41 + this.yOffsetEditor);
        this.add((Component)this.button_patch_erase, 152, 41 + this.yOffsetEditor);
        this.add((Component)this.button_input_save, 128, 377 + this.yOffsetEditor);
        this.add((Component)this.button_input_ignore, 160, 377 + this.yOffsetEditor);
        this.add((Component)this.button_input_dump, 8, 417 + this.yOffsetEditor);
        this.add((Component)this.button_keyboard_down, 396, 353 + this.yOffsetEditor);
        this.add((Component)this.button_keyboard_up, 432, 353 + this.yOffsetEditor);
        this.add((Component)this.button_keyboard_mouse, 532, 353 + this.yOffsetEditor);
        this.add((Component)this.button_keyboard_kybd, 568, 353 + this.yOffsetEditor);
        this.add((Component)this.button_keyboard_panic, 664, 353 + this.yOffsetEditor);
        this.add((Component)this.button_range_16, 300, 89 + this.yOffsetEditor);
        this.add((Component)this.button_range_8, 328, 89 + this.yOffsetEditor);
        this.add((Component)this.button_range_4, 356, 89 + this.yOffsetEditor);
        this.add((Component)this.button_square, 516, 89 + this.yOffsetEditor);
        this.add((Component)this.button_saw, 544, 89 + this.yOffsetEditor);
        this.add((Component)this.button_chorus_OFF, 640, 245 + this.yOffsetEditor);
        this.add((Component)this.button_chorus_I, 668, 245 + this.yOffsetEditor);
        this.add((Component)this.button_chorus_II, 696, 245 + this.yOffsetEditor);
        this.button_input_save.setEnabled(false);
        this.button_input_ignore.setEnabled(false);
        this.range16 = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.range8 = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.range4 = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.square = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.saw = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.chorusI = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.chorusII = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.indicator_dump = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.indicator_manual = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.indicator_received = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.indicator_kybd = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.indicator_mouse = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.indicator_patchsave = new JCustomIndicator(indicatorOn, indicatorOff, 12, 12);
        this.add((Component)this.range16, 308, 73 + this.yOffsetEditor);
        this.add((Component)this.range8, 336, 73 + this.yOffsetEditor);
        this.add((Component)this.range4, 364, 73 + this.yOffsetEditor);
        this.add((Component)this.square, 524, 73 + this.yOffsetEditor);
        this.add((Component)this.saw, 552, 73 + this.yOffsetEditor);
        this.add((Component)this.chorusI, 676, 229 + this.yOffsetEditor);
        this.add((Component)this.chorusII, 704, 229 + this.yOffsetEditor);
        this.add((Component)this.indicator_dump, 6, 401 + this.yOffsetEditor);
        this.add((Component)this.indicator_manual, 74, 401 + this.yOffsetEditor);
        this.add((Component)this.indicator_received, 6, 361 + this.yOffsetEditor);
        this.add((Component)this.indicator_kybd, 576, 337 + this.yOffsetEditor);
        this.add((Component)this.indicator_mouse, 540, 337 + this.yOffsetEditor);
        this.add((Component)this.indicator_patchsave, 376, 4);
        this.indicator_dump.setValue(this.core.inputDumpMode);
        this.indicator_manual.setValue(this.core.manualMode);
        this.indicator_received.setValue(false);
        this.patchName = new JLabel();
        this.patchName.setFont(f);
        this.patchName.setForeground(new Color(204, 0, 17));
        this.patchName.setOpaque(false);
        this.add(this.patchName, 196, 20, 186, 16);
        this.patchName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (!JunoGui.this.core.manualMode && e.getClickCount() > 1 && (index = JunoGui.this.core.getIndexOfActivePatch()) > -1) {
                    JunoGui.this.view.setSelectedIndex(index);
                    JunoGui.this.view.ensureIndexIsVisble(index);
                }
            }
        });
        this.libraryName = new JLabel();
        this.libraryName.setFont(f);
        this.libraryName.setForeground(new Color(204, 0, 17));
        this.libraryName.setOpaque(false);
        this.add(this.libraryName, 12, 20, 164, 16);
        this.setScale(1.25, false);
        this.setScale(1.25, true);
        this.repaint();
        this.sliderPitch.addGuiListener(this.g);
        this.sliderMod.addGuiListener(this.g);
        this.button_range_16.addGuiListener(this.g);
        this.button_range_8.addGuiListener(this.g);
        this.button_range_4.addGuiListener(this.g);
        this.button_square.addGuiListener(this.g);
        this.button_saw.addGuiListener(this.g);
        this.button_chorus_OFF.addGuiListener(this.g);
        this.button_chorus_I.addGuiListener(this.g);
        this.button_chorus_II.addGuiListener(this.g);
        this.sliderLfoRate.addGuiListener(this.g);
        this.sliderLFOdelay.addGuiListener(this.g);
        this.sliderDCOLFO.addGuiListener(this.g);
        this.sliderDCOPWM.addGuiListener(this.g);
        this.slidersublevel.addGuiListener(this.g);
        this.slidernoiselevel.addGuiListener(this.g);
        this.sliderHPfilter.addGuiListener(this.g);
        this.sliderVCFcutoff.addGuiListener(this.g);
        this.sliderresonance.addGuiListener(this.g);
        this.sliderVCFENV.addGuiListener(this.g);
        this.sliderVCFLFO.addGuiListener(this.g);
        this.sliderVCFKYBD.addGuiListener(this.g);
        this.sliderVCAlevel.addGuiListener(this.g);
        this.sliderattack.addGuiListener(this.g);
        this.sliderdecay.addGuiListener(this.g);
        this.slidersustain.addGuiListener(this.g);
        this.sliderrelease.addGuiListener(this.g);
        this.switchPwmSource.addGuiListener(this.g);
        this.switchEnvMode.addGuiListener(this.g);
        this.switchVcaMode.addGuiListener(this.g);
        this.button_patch_new.addGuiListener(this.g);
        this.button_patch_save.addGuiListener(this.g);
        this.button_patch_name.addGuiListener(this.g);
        this.button_patch_duplicate.addGuiListener(this.g);
        this.button_patch_erase.addGuiListener(this.g);
        this.button_patch_edit.addGuiListener(this.g);
        this.button_input_save.addGuiListener(this.g);
        this.button_input_ignore.addGuiListener(this.g);
        this.button_input_dump.addGuiListener(this.g);
        this.button_keyboard_up.addGuiListener(this.g);
        this.button_keyboard_down.addGuiListener(this.g);
        this.button_keyboard_mouse.addGuiListener(this.g);
        this.button_keyboard_kybd.addGuiListener(this.g);
        this.button_keyboard_panic.addGuiListener(this.g);
        this.button_patch_undo.addGuiListener(this.g);
        this.button_patch_compare.addGuiListener(this.g);
        this.button_patch_random.addGuiListener(this.g);
        this.view.addGuiListener(this.g);
        this.button_input_save.setFocusable(false);
        this.button_input_ignore.setFocusable(false);
        this.button_input_dump.setFocusable(false);
        this.button_keyboard_up.setFocusable(false);
        this.button_keyboard_down.setFocusable(false);
        this.button_keyboard_mouse.setFocusable(false);
        this.button_keyboard_kybd.setFocusable(false);
        this.button_keyboard_panic.setFocusable(false);
        this.button_patch_undo.setFocusable(false);
        this.button_patch_compare.setFocusable(false);
        this.button_patch_random.setFocusable(false);
        this.button_patch_new.setFocusable(false);
        this.button_patch_save.setFocusable(false);
        this.button_patch_name.setFocusable(false);
        this.button_patch_duplicate.setFocusable(false);
        this.button_patch_erase.setFocusable(false);
        this.button_patch_edit.setFocusable(false);
        this.sliderMod.setFocusable(false);
        this.sliderPitch.setFocusable(false);
        this.view.setFocusable(true);
        this.cf = new FocusTracer();
        this.cf.addTo(this.view);
        this.cf.addTo(this.sliderLfoRate);
        this.cf.addTo(this.sliderLFOdelay);
        this.cf.addTo(this.button_range_16);
        this.cf.addTo(this.button_range_8);
        this.cf.addTo(this.button_range_4);
        this.cf.addTo(this.sliderDCOLFO);
        this.cf.addTo(this.sliderDCOPWM);
        this.cf.addTo(this.switchPwmSource);
        this.cf.addTo(this.button_square);
        this.cf.addTo(this.button_saw);
        this.cf.addTo(this.slidersublevel);
        this.cf.addTo(this.slidernoiselevel);
        this.cf.addTo(this.sliderHPfilter);
        this.cf.addTo(this.sliderVCFcutoff);
        this.cf.addTo(this.sliderresonance);
        this.cf.addTo(this.switchEnvMode);
        this.cf.addTo(this.sliderVCFENV);
        this.cf.addTo(this.sliderVCFLFO);
        this.cf.addTo(this.sliderVCFKYBD);
        this.cf.addTo(this.switchVcaMode);
        this.cf.addTo(this.sliderVCAlevel);
        this.cf.addTo(this.sliderattack);
        this.cf.addTo(this.sliderdecay);
        this.cf.addTo(this.slidersustain);
        this.cf.addTo(this.sliderrelease);
        this.cf.addTo(this.button_chorus_OFF);
        this.cf.addTo(this.button_chorus_I);
        this.cf.addTo(this.button_chorus_II);
        for (Component component : this.cf.getComponentList()) {
            component.addKeyListener(this.core.midiKeyboard.getKeyListener());
        }
        this.core.mainFrame.setFocusTraversalPolicy(this.cf);
        this.setPatch(new ExtendedPatch());
    }

    public void setScale(double aScale, boolean scaleGui) {
        Component[] allComponents;
        double relativeScale = aScale / this.scale;
        this.scale = aScale;
        Rectangle r = this.getBounds();
        if (scaleGui) {
            this.setSize((int)((double)this.getWidth() * relativeScale), (int)((double)this.getHeight() * relativeScale));
            this.setBounds(0, 0, (int)(r.getWidth() * relativeScale), (int)(r.getHeight() * relativeScale));
        }
        for (Component c : allComponents = this.getComponents()) {
            if (c instanceof JCustomSlider) {
                ((JCustomSlider)c).scale(relativeScale);
            }
            if (c instanceof JCustomButton) {
                ((JCustomButton)c).scale(relativeScale);
            }
            if (!(c instanceof JCustomIndicator)) continue;
            ((JCustomIndicator)c).scale(relativeScale);
        }
        int fontSize = this.fontSize100;
        if (this.scale == 1.25) {
            fontSize = this.fontSize125;
        } else if (this.scale == 1.5) {
            fontSize = this.fontSize150;
        } else if (this.scale == 1.75) {
            fontSize = this.fontSize200;
        }
        Font f = new Font("Monospaced", 1, fontSize);
        this.patchName.setFont(f);
        r = this.patchName.getBounds();
        this.patchName.setBounds((int)(r.getX() * relativeScale), (int)(r.getY() * relativeScale), (int)(r.getWidth() * relativeScale), (int)(r.getHeight() * relativeScale));
        this.libraryName.setFont(f);
        r = this.libraryName.getBounds();
        this.libraryName.setBounds((int)(r.getX() * relativeScale), (int)(r.getY() * relativeScale), (int)(r.getWidth() * relativeScale), (int)(r.getHeight() * relativeScale));
        this.receivedPatchName.setFont(f);
        r = this.receivedPatchName.getBounds();
        this.receivedPatchName.setBounds((int)(r.getX() * relativeScale), (int)(r.getY() * relativeScale), (int)(r.getWidth() * relativeScale), (int)(r.getHeight() * relativeScale));
        this.view.scale(relativeScale, fontSize);
        this.core.midiKeyboard.scale(relativeScale);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setLibrary(ExtendedLibrary l, int selected) {
        this.view.setLibrary(l);
        this.view.setSelectedIndex(selected);
        this.libraryName.setText(l.getName());
    }

    public void setExternalMode() {
        boolean b = false;
        this.receivedPatchName.setText("External");
        this.receivedPatchName.setEnabled(true);
        this.core.manualMode = true;
        this.indicator_manual.setValue(true);
        this.indicator_received.setValue(false);
        this.indicator_patchsave.setValue(false);
        this.button_range_16.setEnabled(b);
        this.button_range_8.setEnabled(b);
        this.button_range_4.setEnabled(b);
        this.button_square.setEnabled(b);
        this.button_saw.setEnabled(b);
        this.button_chorus_OFF.setEnabled(b);
        this.button_chorus_I.setEnabled(b);
        this.button_chorus_II.setEnabled(b);
        this.sliderLfoRate.setEnabled(b);
        this.sliderLFOdelay.setEnabled(b);
        this.sliderDCOLFO.setEnabled(b);
        this.sliderDCOPWM.setEnabled(b);
        this.slidersublevel.setEnabled(b);
        this.slidernoiselevel.setEnabled(b);
        this.sliderHPfilter.setEnabled(b);
        this.sliderVCFcutoff.setEnabled(b);
        this.sliderresonance.setEnabled(b);
        this.sliderVCFENV.setEnabled(b);
        this.sliderVCFLFO.setEnabled(b);
        this.sliderVCFKYBD.setEnabled(b);
        this.sliderVCAlevel.setEnabled(b);
        this.sliderattack.setEnabled(b);
        this.sliderdecay.setEnabled(b);
        this.slidersustain.setEnabled(b);
        this.sliderrelease.setEnabled(b);
        this.switchPwmSource.setEnabled(b);
        this.switchEnvMode.setEnabled(b);
        this.switchVcaMode.setEnabled(b);
        this.button_patch_new.setEnabled(b);
        this.button_patch_save.setEnabled(b);
        this.button_patch_name.setEnabled(b);
        this.button_patch_duplicate.setEnabled(b);
        this.button_patch_erase.setEnabled(b);
        this.button_patch_edit.setEnabled(b);
        this.button_input_save.setEnabled(false);
        this.button_input_ignore.setEnabled(!b);
        this.button_input_dump.setEnabled(b);
        this.view.setEnabled(false);
        this.repaint();
    }

    public void setEditorEnabled(boolean b) {
        this.button_range_16.setEnabled(b);
        this.button_range_8.setEnabled(b);
        this.button_range_4.setEnabled(b);
        this.button_square.setEnabled(b);
        this.button_saw.setEnabled(b);
        this.button_chorus_OFF.setEnabled(b);
        this.button_chorus_I.setEnabled(b);
        this.button_chorus_II.setEnabled(b);
        this.sliderLfoRate.setEnabled(b);
        this.sliderLFOdelay.setEnabled(b);
        this.sliderDCOLFO.setEnabled(b);
        this.sliderDCOPWM.setEnabled(b);
        this.slidersublevel.setEnabled(b);
        this.slidernoiselevel.setEnabled(b);
        this.sliderHPfilter.setEnabled(b);
        this.sliderVCFcutoff.setEnabled(b);
        this.sliderresonance.setEnabled(b);
        this.sliderVCFENV.setEnabled(b);
        this.sliderVCFLFO.setEnabled(b);
        this.sliderVCFKYBD.setEnabled(b);
        this.sliderVCAlevel.setEnabled(b);
        this.sliderattack.setEnabled(b);
        this.sliderdecay.setEnabled(b);
        this.slidersustain.setEnabled(b);
        this.sliderrelease.setEnabled(b);
        this.switchPwmSource.setEnabled(b);
        this.switchEnvMode.setEnabled(b);
        this.switchVcaMode.setEnabled(b);
        this.view.setEnabled(b);
        this.repaint();
    }

    @Override
    public void setEnabled(boolean b) {
        this.sliderPitch.setEnabled(b);
        this.sliderMod.setEnabled(b);
        this.button_range_16.setEnabled(b);
        this.button_range_8.setEnabled(b);
        this.button_range_4.setEnabled(b);
        this.button_square.setEnabled(b);
        this.button_saw.setEnabled(b);
        this.button_chorus_OFF.setEnabled(b);
        this.button_chorus_I.setEnabled(b);
        this.button_chorus_II.setEnabled(b);
        this.sliderLfoRate.setEnabled(b);
        this.sliderLFOdelay.setEnabled(b);
        this.sliderDCOLFO.setEnabled(b);
        this.sliderDCOPWM.setEnabled(b);
        this.slidersublevel.setEnabled(b);
        this.slidernoiselevel.setEnabled(b);
        this.sliderHPfilter.setEnabled(b);
        this.sliderVCFcutoff.setEnabled(b);
        this.sliderresonance.setEnabled(b);
        this.sliderVCFENV.setEnabled(b);
        this.sliderVCFLFO.setEnabled(b);
        this.sliderVCFKYBD.setEnabled(b);
        this.sliderVCAlevel.setEnabled(b);
        this.sliderattack.setEnabled(b);
        this.sliderdecay.setEnabled(b);
        this.slidersustain.setEnabled(b);
        this.sliderrelease.setEnabled(b);
        this.switchPwmSource.setEnabled(b);
        this.switchEnvMode.setEnabled(b);
        this.switchVcaMode.setEnabled(b);
        this.button_patch_new.setEnabled(b);
        this.button_patch_save.setEnabled(b);
        this.button_patch_name.setEnabled(b);
        this.button_patch_duplicate.setEnabled(b);
        this.button_patch_erase.setEnabled(b);
        this.button_patch_edit.setEnabled(b);
        this.button_input_save.setEnabled(b);
        this.button_input_ignore.setEnabled(b);
        this.button_input_dump.setEnabled(b);
        this.button_keyboard_up.setEnabled(b);
        this.button_keyboard_down.setEnabled(b);
        this.button_keyboard_mouse.setEnabled(b);
        this.button_keyboard_kybd.setEnabled(b);
        this.button_keyboard_panic.setEnabled(b);
        this.button_patch_undo.setEnabled(this.core.hasUndoData());
        this.view.setEnabled(b);
        this.repaint();
    }

    public void setPatch(ExtendedPatch p) {
        this.sliderLfoRate.setValue(p.getLFOrate());
        this.sliderLFOdelay.setValue(p.getLFOdelay());
        this.sliderDCOLFO.setValue(p.getDCOLFO());
        this.sliderDCOPWM.setValue(p.getDCOPWM());
        this.slidersublevel.setValue(p.getsublevel());
        this.slidernoiselevel.setValue(p.getnoiselevel());
        this.sliderVCFcutoff.setValue(p.getVCFcutoff());
        this.sliderresonance.setValue(p.getresonance());
        this.sliderVCFENV.setValue(p.getVCFENV());
        this.sliderVCFLFO.setValue(p.getVCFLFO());
        this.sliderVCFKYBD.setValue(p.getVCFKYBD());
        this.sliderVCAlevel.setValue(p.getVCAlevel());
        this.sliderattack.setValue(p.getattack());
        this.sliderdecay.setValue(p.getdecay());
        this.slidersustain.setValue(p.getsustain());
        this.sliderrelease.setValue(p.getrelease());
        this.sliderHPfilter.setValue(p.getHPfilter());
        this.range16.setValue(p.getrange() == 16);
        this.range8.setValue(p.getrange() == 8);
        this.range4.setValue(p.getrange() == 4);
        this.square.setValue(p.getpulse());
        this.saw.setValue(p.getsaw());
        this.chorusI.setValue(p.getchorus() == 1);
        this.chorusII.setValue(p.getchorus() == 2);
        if (p.getPWM() == "MAN") {
            this.switchPwmSource.setValue(0);
        } else {
            this.switchPwmSource.setValue(1);
        }
        if (p.getENV() == "-") {
            this.switchEnvMode.setValue(0);
        } else {
            this.switchEnvMode.setValue(1);
        }
        if (p.getVCA() == "gate") {
            this.switchVcaMode.setValue(0);
        } else {
            this.switchVcaMode.setValue(1);
        }
        this.patchName.setText(p.getName());
    }

    public class GuiListener
    extends MouseAdapter
    implements JCustomListener {
        @Override
        public void processEvent(JCustomEvent e) {
            ComponentId id = (ComponentId)e.getSourceId();
            if (e.getType() == JCustomEvent.EventType.RELEASE && id != ComponentId.k_button_patch_compare && id != ComponentId.k_button_patch_random) {
                return;
            }
            switch (id.ordinal()) {
                case 0: {
                    if (JunoGui.this.range16.getValue()) break;
                    JunoGui.this.range16.setValue(true);
                    JunoGui.this.range8.setValue(false);
                    JunoGui.this.range4.setValue(false);
                    JunoGui.this.core.controlChange(ControllerId.k_button_range, 16);
                    break;
                }
                case 1: {
                    if (JunoGui.this.range8.getValue()) break;
                    JunoGui.this.range16.setValue(false);
                    JunoGui.this.range8.setValue(true);
                    JunoGui.this.range4.setValue(false);
                    JunoGui.this.core.controlChange(ControllerId.k_button_range, 8);
                    break;
                }
                case 2: {
                    if (JunoGui.this.range4.getValue()) break;
                    JunoGui.this.range16.setValue(false);
                    JunoGui.this.range8.setValue(false);
                    JunoGui.this.range4.setValue(true);
                    JunoGui.this.core.controlChange(ControllerId.k_button_range, 4);
                    break;
                }
                case 3: {
                    if (JunoGui.this.square.getValue()) {
                        JunoGui.this.core.controlChange(ControllerId.k_button_square, 0);
                        JunoGui.this.square.setValue(false);
                        break;
                    }
                    JunoGui.this.core.controlChange(ControllerId.k_button_square, 1);
                    JunoGui.this.square.setValue(true);
                    break;
                }
                case 4: {
                    if (JunoGui.this.saw.getValue()) {
                        JunoGui.this.core.controlChange(ControllerId.k_button_saw, 0);
                    } else {
                        JunoGui.this.core.controlChange(ControllerId.k_button_saw, 1);
                    }
                    JunoGui.this.saw.switchValue();
                    break;
                }
                case 5: {
                    if (!JunoGui.this.chorusI.getValue() && !JunoGui.this.chorusII.getValue()) break;
                    JunoGui.this.core.controlChange(ControllerId.k_button_chorus, 0);
                    JunoGui.this.chorusI.setValue(false);
                    JunoGui.this.chorusII.setValue(false);
                    break;
                }
                case 6: {
                    if (JunoGui.this.chorusI.getValue()) break;
                    JunoGui.this.core.controlChange(ControllerId.k_button_chorus, 1);
                    JunoGui.this.chorusI.setValue(true);
                    JunoGui.this.chorusII.setValue(false);
                    break;
                }
                case 7: {
                    if (JunoGui.this.chorusII.getValue()) break;
                    JunoGui.this.core.controlChange(ControllerId.k_button_chorus, 2);
                    JunoGui.this.chorusI.setValue(false);
                    JunoGui.this.chorusII.setValue(true);
                    break;
                }
                case 8: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderLfoRate, e.getValue());
                    break;
                }
                case 9: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderLFOdelay, e.getValue());
                    break;
                }
                case 10: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderDCOLFO, e.getValue());
                    break;
                }
                case 11: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderDCOPWM, e.getValue());
                    break;
                }
                case 12: {
                    JunoGui.this.core.controlChange(ControllerId.k_slidersublevel, e.getValue());
                    break;
                }
                case 13: {
                    JunoGui.this.core.controlChange(ControllerId.k_slidernoiselevel, e.getValue());
                    break;
                }
                case 14: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderVCFcutoff, e.getValue());
                    break;
                }
                case 15: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderresonance, e.getValue());
                    break;
                }
                case 16: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderVCFENV, e.getValue());
                    break;
                }
                case 17: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderVCFLFO, e.getValue());
                    break;
                }
                case 18: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderVCFKYBD, e.getValue());
                    break;
                }
                case 19: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderVCAlevel, e.getValue());
                    break;
                }
                case 20: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderattack, e.getValue());
                    break;
                }
                case 21: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderdecay, e.getValue());
                    break;
                }
                case 22: {
                    JunoGui.this.core.controlChange(ControllerId.k_slidersustain, e.getValue());
                    break;
                }
                case 23: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderrelease, e.getValue());
                    break;
                }
                case 24: {
                    JunoGui.this.core.controlChange(ControllerId.k_sliderHPfilter, e.getValue());
                    break;
                }
                case 25: {
                    JunoGui.this.core.controlChange(ControllerId.k_switchPwmSource, e.getValue());
                    break;
                }
                case 26: {
                    JunoGui.this.core.controlChange(ControllerId.k_switchEnvMode, e.getValue());
                    break;
                }
                case 27: {
                    JunoGui.this.core.controlChange(ControllerId.k_switchVcaMode, e.getValue());
                    break;
                }
                case 34: 
                case 48: {
                    if (JunoGui.this.view.getSelectedIndex() == -1) break;
                    int index = JunoGui.this.view.getSelectedIndex();
                    JunoGui.this.core.setActivePatch(JunoGui.this.core.getPatchAt(index));
                    break;
                }
                case 28: {
                    ExtendedPatch p = new ExtendedPatch();
                    int index = JunoGui.this.core.addPatchClever(p);
                    if (JunoGui.this.core.getLibrarySize() == 1) {
                        JunoGui.this.view.setSelectedIndex(0);
                    }
                    JunoGui.this.core.triggerLibraryViewUpdate(index);
                    break;
                }
                case 29: {
                    JunoGui.this.core.saveActivePatch();
                    break;
                }
                case 30: {
                    int selected = JunoGui.this.view.getSelectedIndex();
                    if (selected != -1) {
                        JunoGui.this.view.ensureIndexIsVisble(selected);
                        JunoGui.this.view.updateContent();
                        int index = selected;
                        ExtendedPatch p = new ExtendedPatch(JunoGui.this.core.getPatchAt(index));
                        String s = JOptionPane.showInputDialog(JunoGui.this.core.mainFrame, "Name of Patch", p.getName());
                        if (s == null || s.equals(p.getName())) {
                            JunoGui.this.button_patch_name.reset();
                            return;
                        }
                        if (s.equals("")) {
                            JOptionPane.showMessageDialog(JunoGui.this.core.mainFrame, "Invalid name. Empty.");
                            JunoGui.this.button_patch_name.reset();
                            return;
                        }
                        if (JunoGui.this.core.hasPatch(s)) {
                            JOptionPane.showMessageDialog(JunoGui.this.core.mainFrame, "Invalid name, library already contains patch with this name.");
                            JunoGui.this.button_patch_name.reset();
                            return;
                        }
                        if (p.getName().equals(JunoGui.this.core.getActivePatchName())) {
                            JunoGui.this.patchName.setText(s);
                            JunoGui.this.core.setActivePatchName(s);
                        }
                        p.setName(s);
                        JunoGui.this.core.removePatchAt(index);
                        JunoGui.this.core.addPatch(new ExtendedPatch(p));
                        int newSelected = JunoGui.this.core.getIndexOf(p);
                        JunoGui.this.view.setSelectedIndex(newSelected);
                        JunoGui.this.view.ensureIndexIsVisble(newSelected);
                        JunoGui.this.view.updateContent();
                    }
                    JunoGui.this.button_patch_name.reset();
                    break;
                }
                case 31: {
                    int selected = JunoGui.this.view.getSelectedIndex();
                    if (selected == -1) break;
                    ExtendedPatch copy = new ExtendedPatch(JunoGui.this.core.getPatchAt(selected));
                    int newPatch = JunoGui.this.core.addPatchClever(copy);
                    JunoGui.this.view.ensureIndexIsVisble(newPatch);
                    JunoGui.this.view.updateContent();
                    break;
                }
                case 32: 
                case 33: {
                    int selected = JunoGui.this.view.getSelectedIndex();
                    if (selected == -1) break;
                    if (JunoGui.this.core.getPatchAt(selected).getName().equals(JunoGui.this.core.getActivePatchName())) {
                        int opt = JOptionPane.showConfirmDialog(JunoGui.this.core.mainFrame, "Remove active patch from library?", "Warning", 2);
                        JunoGui.this.button_patch_erase.reset();
                        if (opt == 2) {
                            return;
                        }
                    }
                    if (selected == JunoGui.this.core.getLibrarySize() - 1) {
                        JunoGui.this.view.setSelectedIndex(selected - 1);
                    }
                    JunoGui.this.core.removePatchAt(selected);
                    JunoGui.this.view.updateContent();
                    break;
                }
                case 35: {
                    JunoGui.this.core.getReceivedPatch().setName(JunoGui.this.receivedPatchName.getText());
                    JunoGui.this.core.addPatch(JunoGui.this.core.getReceivedPatch());
                    JunoGui.this.view.updateContent();
                    JunoGui.this.core.setReceivedPatch(null);
                    JunoGui.this.receivedPatchName.setText("-------");
                    JunoGui.this.receivedPatchName.setEnabled(false);
                    JunoGui.this.button_input_save.setEnabled(false);
                    JunoGui.this.button_input_ignore.setEnabled(false);
                    JunoGui.this.core.manualMode = false;
                    JunoGui.this.indicator_received.setValue(false);
                    break;
                }
                case 36: {
                    if (JunoGui.this.core.manualMode) {
                        JunoGui.this.core.exitManualMode();
                    } else {
                        JunoGui.this.core.getReceivedPatch().setName(JunoGui.this.receivedPatchName.getText());
                    }
                    JunoGui.this.core.setReceivedPatch(null);
                    JunoGui.this.receivedPatchName.setText("-------");
                    JunoGui.this.receivedPatchName.setEnabled(false);
                    JunoGui.this.button_input_save.setEnabled(false);
                    JunoGui.this.button_input_ignore.setEnabled(false);
                    JunoGui.this.core.manualMode = false;
                    JunoGui.this.indicator_received.setValue(false);
                    break;
                }
                case 42: {
                    JunoGui.this.core.inputDumpMode = !JunoGui.this.core.inputDumpMode;
                    JunoGui.this.indicator_dump.setValue(JunoGui.this.core.inputDumpMode);
                    JunoGui.this.core.setReceivedPatch(null);
                    JunoGui.this.receivedPatchName.setText("-------");
                    JunoGui.this.receivedPatchName.setEnabled(JunoGui.this.core.inputDumpMode);
                    JunoGui.this.button_input_save.setEnabled(false);
                    JunoGui.this.button_input_ignore.setEnabled(false);
                    JunoGui.this.indicator_received.setValue(false);
                    break;
                }
                case 45: {
                    JunoGui.this.core.undo();
                    break;
                }
                case 46: {
                    if (e.getType() != JCustomEvent.EventType.RELEASE) {
                        JunoGui.this.core.startCompare();
                        break;
                    }
                    JunoGui.this.core.endCompare();
                    break;
                }
                case 47: {
                    if (e.getType() == JCustomEvent.EventType.RELEASE) break;
                    JunoGui.this.core.randomize();
                    break;
                }
                case 37: {
                    if (!JunoGui.this.button_keyboard_down.isEnabled()) {
                        JunoGui.this.button_keyboard_down.setEnabled(true);
                    }
                    JunoGui.this.core.midiKeyboard.increaseOctave();
                    if (JunoGui.this.core.midiKeyboard.canIncreaseOctave()) break;
                    JunoGui.this.button_keyboard_up.setEnabled(false);
                    break;
                }
                case 38: {
                    if (!JunoGui.this.button_keyboard_up.isEnabled()) {
                        JunoGui.this.button_keyboard_up.setEnabled(true);
                    }
                    JunoGui.this.core.midiKeyboard.decreaseOctave();
                    if (JunoGui.this.core.midiKeyboard.canDecreaseOctave()) break;
                    JunoGui.this.button_keyboard_down.setEnabled(false);
                    break;
                }
                case 39: {
                    JunoGui.this.core.midiKeyboard.setMouseEnabled(!JunoGui.this.core.midiKeyboard.isMouseEnabled());
                    JunoGui.this.indicator_mouse.switchValue();
                    break;
                }
                case 40: {
                    JunoGui.this.core.midiKeyboard.setAbcEnabled(!JunoGui.this.core.midiKeyboard.isAbcEnabled());
                    JunoGui.this.indicator_kybd.switchValue();
                    break;
                }
                case 41: {
                    JunoGui.this.core.midiKeyboard.allNotesOff();
                    break;
                }
                case 43: {
                    JunoGui.this.core.midiKeyboard.pitchBend(e.getValue());
                    break;
                }
                case 44: {
                    JunoGui.this.core.midiKeyboard.modulation(e.getValue());
                }
            }
        }
    }

    public static enum ComponentId implements JCustomEvent.SourceId
    {
        k_button_range_16,
        k_button_range_8,
        k_button_range_4,
        k_button_square,
        k_button_saw,
        k_button_chorus_OFF,
        k_button_chorus_I,
        k_button_chorus_II,
        k_sliderLfoRate,
        k_sliderLFOdelay,
        k_sliderDCOLFO,
        k_sliderDCOPWM,
        k_slidersublevel,
        k_slidernoiselevel,
        k_sliderVCFcutoff,
        k_sliderresonance,
        k_sliderVCFENV,
        k_sliderVCFLFO,
        k_sliderVCFKYBD,
        k_sliderVCAlevel,
        k_sliderattack,
        k_sliderdecay,
        k_slidersustain,
        k_sliderrelease,
        k_sliderHPfilter,
        k_switchPwmSource,
        k_switchEnvMode,
        k_switchVcaMode,
        k_button_patch_new,
        k_button_patch_save,
        k_button_patch_name,
        k_button_patch_duplicate,
        k_button_patch_erase,
        k_view_erase,
        k_button_patch_edit,
        k_button_input_save,
        k_button_input_ignore,
        k_button_keyboard_up,
        k_button_keyboard_down,
        k_button_keyboard_mouse,
        k_button_keyboard_kybd,
        k_button_keyboard_panic,
        k_button_input_dump,
        k_sliderPitch,
        k_sliderMod,
        k_button_patch_undo,
        k_button_patch_compare,
        k_button_patch_random,
        k_view_edit;

    }

    public static class MouseWheelEventFilter {
        long timestamp = 0L;
        long minDeltaT = 3L;
        int currentSign = 0;

        public boolean filterMouseWheelEvent(MouseWheelEvent anEvent) {
            int sign = (int)Math.signum(anEvent.getWheelRotation());
            if (this.currentSign != sign && anEvent.getWhen() - this.timestamp < this.minDeltaT) {
                return false;
            }
            this.timestamp = anEvent.getWhen();
            this.currentSign = sign;
            return true;
        }
    }

    public static enum ControllerId {
        k_button_range,
        k_button_square,
        k_button_saw,
        k_button_chorus,
        k_sliderLfoRate,
        k_sliderLFOdelay,
        k_sliderDCOLFO,
        k_sliderDCOPWM,
        k_slidersublevel,
        k_slidernoiselevel,
        k_sliderVCFcutoff,
        k_sliderresonance,
        k_sliderVCFENV,
        k_sliderVCFLFO,
        k_sliderVCFKYBD,
        k_sliderVCAlevel,
        k_sliderattack,
        k_sliderdecay,
        k_slidersustain,
        k_sliderrelease,
        k_sliderHPfilter,
        k_switchPwmSource,
        k_switchEnvMode,
        k_switchVcaMode,
        k_controlUndefined;

    }
}

