/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.bjno.j106.gui.JunoGui;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.jcustomgui.JCustomButton;
import org.bjno.jcustomgui.JCustomEvent;
import org.bjno.jcustomgui.JCustomListener;
import org.bjno.jcustomgui.JCustomPanel;
import org.bjno.jcustomgui.JCustomSlider;

public class LibraryView
extends JCustomPanel {
    private static final int KEY_CHANGE_AMPLITUDE = 1;
    private static final int KEY_CHANGE_AMPLITUDE_FAST = 8;
    int sliderMax = 256;
    private int numberOfRows;
    private int numberOfContentRows;
    private int selectedIndex = 0;
    private int width;
    private int height;
    private int slideBarButtonHeight;
    private int inset = 4;
    private int rowHeight = 16;
    ArrayList<JLabel> labels;
    int offset = 0;
    Font font;
    Font fontSelected;
    Color textColor = new Color(204, 0, 17);
    Color textColor2 = new Color(234, 0, 17);
    Color backgroundColor = new Color(83, 0, 4);
    JCustomSlider sliderview;
    JCustomButton viewButtonUp;
    JCustomButton viewButtonDown;
    JCustomPanel hider;
    boolean active;
    boolean enabled = true;
    private Color activeBorderColor = new Color(204, 0, 17);
    ExtendedLibrary theContentLibrary;
    public String selectedPatch;
    private ArrayList<JCustomListener> actionListeners = new ArrayList();

    public LibraryView(Image background, Image sliderhandle, Image buttonUp, Image buttonDown, int aWidth, int aHeight, int aSlideBarWidth, int aSlidebarButtonHeight, int aFontSize) {
        super(aWidth, aHeight);
        this.setOpaque(false);
        this.width = aWidth;
        this.height = aHeight;
        this.slideBarButtonHeight = aSlidebarButtonHeight;
        this.font = new Font("Monospaced", 0, aFontSize);
        this.fontSelected = new Font("Monospaced", 1, aFontSize);
        this.numberOfRows = (this.height - 2 * this.inset) / this.rowHeight;
        this.addMouseWheelListener(new MouseWheelListener());
        this.addKeyListener(new keyHandler());
        EmptyBorder border = new EmptyBorder(0, 0, 0, 0);
        this.hider = new JCustomPanel(this.width, this.height);
        this.hider.setBackground(new Color(0, 0, 0, 64));
        this.hider.setVisible(false);
        this.add((Component)this.hider, 0, 0);
        this.sliderview = new JCustomSlider(ComponentId.k_sliderview, sliderhandle, aSlideBarWidth - 1, this.height - 2 * this.slideBarButtonHeight, aSlideBarWidth - 1, this.height - 2 * this.slideBarButtonHeight, 0, this.sliderMax, false);
        this.sliderview.setMouseWheelEnabled(false);
        this.sliderview.setFocusable(false);
        this.add((Component)this.sliderview, this.width - aSlideBarWidth, this.slideBarButtonHeight);
        this.viewButtonUp = new JCustomButton(ComponentId.k_viewButtonUp, buttonUp, buttonUp, aSlideBarWidth, this.slideBarButtonHeight);
        this.viewButtonDown = new JCustomButton(ComponentId.k_viewButtonDown, buttonDown, buttonDown, aSlideBarWidth, this.slideBarButtonHeight);
        this.viewButtonUp.setFocusable(false);
        this.viewButtonDown.setFocusable(false);
        this.add((Component)this.viewButtonUp, this.width - aSlideBarWidth, 0);
        this.add((Component)this.viewButtonDown, this.width - aSlideBarWidth, this.height - this.slideBarButtonHeight);
        this.labels = new ArrayList(this.numberOfRows);
        for (int i = 0; i < this.numberOfRows; ++i) {
            this.labels.add(new JLabel());
            this.labels.get(i).setFont(this.font);
            this.labels.get(i).setForeground(this.textColor);
            this.labels.get(i).setBorder(border);
            this.labels.get(i).setBackground(this.backgroundColor);
            this.labels.get(i).addMouseListener(new ClickTracer());
            this.add(this.labels.get(i), this.inset, this.inset + i * this.rowHeight, this.width - 2 * this.inset - aSlideBarWidth, this.rowHeight);
        }
        GuiListener guiListener = new GuiListener();
        this.sliderview.addGuiListener(guiListener);
        this.viewButtonUp.addGuiListener(guiListener);
        this.viewButtonDown.addGuiListener(guiListener);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                LibraryView.this.active = false;
                LibraryView.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                LibraryView.this.active = true;
                LibraryView.this.repaint();
            }
        });
    }

    public void scale(double aScale, int aFontSize) {
        Rectangle b = this.getBounds();
        this.setBounds((int)(b.getX() * aScale), (int)(b.getY() * aScale), (int)(b.getWidth() * aScale), (int)(b.getHeight() * aScale));
        this.width = (int)(b.getWidth() * aScale);
        this.height = (int)(b.getHeight() * aScale);
        this.hider.setBounds((int)(b.getX() * aScale), (int)(b.getY() * aScale), (int)(b.getWidth() * aScale), (int)(b.getHeight() * aScale));
        this.font = new Font(this.fontSelected.getFontName(), 0, aFontSize);
        this.fontSelected = new Font(this.fontSelected.getFontName(), 1, aFontSize);
        for (int i = 0; i < this.numberOfRows; ++i) {
            b = this.labels.get(i).getBounds();
            this.labels.get(i).setBounds((int)(b.getX() * aScale), (int)(b.getY() * aScale), (int)(b.getWidth() * aScale), (int)(b.getHeight() * aScale));
            if (i + this.offset == this.selectedIndex) {
                this.labels.get(i).setFont(this.fontSelected);
                continue;
            }
            this.labels.get(i).setFont(this.font);
        }
        this.sliderview.scale(aScale);
        this.viewButtonDown.scale(aScale);
        this.viewButtonUp.scale(aScale);
        this.repaint();
    }

    @Override
    public void setEnabled(boolean anEnabled) {
        this.hider.setVisible(!anEnabled);
        this.enabled = anEnabled;
        this.repaint();
    }

    public void setLibrary(ExtendedLibrary e) {
        this.theContentLibrary = e;
        this.offset = 0;
        this.updateContent();
    }

    private void deltaOffset(int delta) {
        if (this.numberOfContentRows > this.numberOfRows) {
            int oldOffset = this.offset;
            this.offset += delta;
            if (this.offset < 0) {
                this.offset = 0;
            }
            if (this.offset > this.numberOfContentRows - this.numberOfRows) {
                this.offset = this.numberOfContentRows - this.numberOfRows;
            }
            if (oldOffset != this.offset) {
                this.privateUpdate();
            }
        }
    }

    private void setOffset(double d) {
        int oldOffset = this.offset;
        this.offset = (int)(d * (double)(this.numberOfContentRows - this.numberOfRows));
        if (oldOffset != this.offset) {
            this.privateUpdate();
        }
    }

    private double getOffset() {
        return (double)this.offset / (double)(this.numberOfContentRows - this.numberOfRows);
    }

    public void updateContent() {
        this.numberOfContentRows = this.theContentLibrary.size();
        int knobHeight = (int)((double)(this.height - 2 * this.slideBarButtonHeight) * (double)this.numberOfRows / (double)this.numberOfContentRows);
        if (knobHeight > this.height - 2 * this.slideBarButtonHeight) {
            knobHeight = this.height - 2 * this.slideBarButtonHeight;
        }
        this.sliderview.setKnobHeight(knobHeight);
        this.updateSliderPosition();
        this.privateUpdate();
    }

    private void updateSliderPosition() {
        int newSliderValue = this.sliderMax - (int)((double)this.sliderMax * (double)this.offset / (double)(this.numberOfContentRows - this.numberOfRows));
        if (newSliderValue != this.sliderview.getValue()) {
            this.sliderview.setValue(newSliderValue);
        }
    }

    private void privateUpdate() {
        if (this.offset > 0 && this.offset + this.numberOfRows > this.numberOfContentRows) {
            --this.offset;
        }
        for (int i = 0; i < this.labels.size(); ++i) {
            if (i < this.theContentLibrary.size()) {
                this.labels.get(i).setText(this.theContentLibrary.getPatch(i + this.offset).getName());
            } else {
                this.labels.get(i).setText("");
            }
            if (i + this.offset == this.selectedIndex) {
                this.labels.get(i).setFont(this.fontSelected);
                this.labels.get(i).setForeground(this.textColor2);
                this.labels.get(i).setOpaque(true);
                continue;
            }
            this.labels.get(i).setFont(this.font);
            this.labels.get(i).setOpaque(false);
            this.labels.get(i).setForeground(this.textColor);
        }
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void addGuiListener(JCustomListener l) {
        this.actionListeners.add(l);
    }

    public void removeGuiListener(JCustomListener l) {
        this.actionListeners.remove(l);
    }

    public void setSelectedIndex(int i) {
        if (this.selectedIndex != i) {
            this.selectedIndex = i;
        }
        this.privateUpdate();
    }

    public void ensureIndexIsVisble(int i) {
        if (i < this.offset) {
            this.offset = i;
        } else if (i > this.offset + this.numberOfRows - 1) {
            this.offset = i - this.numberOfRows + 1;
        }
        this.privateUpdate();
    }

    private void notifyActionListeners(JCustomEvent anEvent) {
        for (JCustomListener actionListener : this.actionListeners) {
            actionListener.processEvent(anEvent);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.active && this.enabled) {
            g.setColor(this.activeBorderColor);
            g.drawRect(0, 0, this.width, this.height);
        }
    }

    private class MouseWheelListener
    extends MouseAdapter {
        JunoGui.MouseWheelEventFilter filter = new JunoGui.MouseWheelEventFilter();

        private MouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!LibraryView.this.enabled) {
                return;
            }
            LibraryView.this.requestFocus();
            if (!this.filter.filterMouseWheelEvent(e)) {
                return;
            }
            LibraryView.this.deltaOffset(e.getWheelRotation());
            LibraryView.this.sliderview.setValue(LibraryView.this.sliderMax - (int)((double)LibraryView.this.sliderMax * (double)LibraryView.this.offset / (double)(LibraryView.this.numberOfContentRows - LibraryView.this.numberOfRows)));
            LibraryView.this.updateSliderPosition();
        }
    }

    private class keyHandler
    extends KeyAdapter {
        private keyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!LibraryView.this.enabled) {
                return;
            }
            if (LibraryView.this.selectedIndex < 0 || LibraryView.this.selectedIndex > LibraryView.this.numberOfContentRows - 1) {
                return;
            }
            if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                LibraryView.this.notifyActionListeners(new JCustomEvent(JunoGui.ComponentId.k_view_erase, 0));
                return;
            }
            if (e.getKeyCode() == 40 && LibraryView.this.selectedIndex < LibraryView.this.numberOfContentRows) {
                LibraryView.this.selectedIndex += e.isAltDown() ? 8 : 1;
                LibraryView.this.selectedIndex = Math.min(LibraryView.this.selectedIndex, LibraryView.this.numberOfContentRows - 1);
                LibraryView.this.ensureIndexIsVisble(LibraryView.this.selectedIndex);
                LibraryView.this.privateUpdate();
                LibraryView.this.updateSliderPosition();
            }
            if (e.getKeyCode() == 38 && LibraryView.this.selectedIndex > 0) {
                LibraryView.this.selectedIndex -= e.isAltDown() ? 8 : 1;
                LibraryView.this.selectedIndex = Math.max(LibraryView.this.selectedIndex, 0);
                LibraryView.this.ensureIndexIsVisble(LibraryView.this.selectedIndex);
                LibraryView.this.privateUpdate();
                LibraryView.this.updateSliderPosition();
            }
            if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                LibraryView.this.ensureIndexIsVisble(LibraryView.this.selectedIndex);
                LibraryView.this.privateUpdate();
                LibraryView.this.notifyActionListeners(new JCustomEvent(JunoGui.ComponentId.k_view_edit, 0));
            }
        }
    }

    private static enum ComponentId implements JCustomEvent.SourceId
    {
        k_sliderview,
        k_viewButtonUp,
        k_viewButtonDown;

    }

    class ClickTracer
    extends MouseAdapter {
        ClickTracer() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!LibraryView.this.enabled) {
                return;
            }
            LibraryView.this.requestFocus();
            JLabel originator = (JLabel)e.getComponent();
            int index = LibraryView.this.labels.lastIndexOf(originator);
            if (index < LibraryView.this.numberOfContentRows) {
                LibraryView.this.selectedIndex = index + LibraryView.this.offset;
                LibraryView.this.selectedPatch = originator.getText();
                LibraryView.this.privateUpdate();
                LibraryView.this.updateSliderPosition();
                if (e.getClickCount() > 1) {
                    LibraryView.this.notifyActionListeners(new JCustomEvent(JunoGui.ComponentId.k_view_edit, 0));
                }
            }
        }
    }

    public class GuiListener
    implements JCustomListener {
        @Override
        public void processEvent(JCustomEvent e) {
            if (!LibraryView.this.enabled) {
                return;
            }
            LibraryView.this.requestFocus();
            ComponentId id = (ComponentId)e.getSourceId();
            if (id == ComponentId.k_sliderview) {
                LibraryView.this.setOffset(1.0 - (double)LibraryView.this.sliderview.getValue() / (double)LibraryView.this.sliderMax);
            }
            if (id == ComponentId.k_viewButtonUp) {
                LibraryView.this.deltaOffset(-1);
                LibraryView.this.sliderview.setValue(LibraryView.this.sliderMax - (int)(LibraryView.this.getOffset() * (double)LibraryView.this.sliderMax));
            }
            if (id == ComponentId.k_viewButtonDown) {
                LibraryView.this.deltaOffset(1);
                LibraryView.this.sliderview.setValue(LibraryView.this.sliderMax - (int)(LibraryView.this.getOffset() * (double)LibraryView.this.sliderMax));
            }
        }
    }
}

