/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.AWTKeyStroke;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;

public class MainFrame
extends JFrame
implements ActionListener {
    Core core;
    private JMenuBar menuBar = new JMenuBar();
    public JMenu menuSystem = new JMenu("File");
    public JMenu menuLibrary = new JMenu("Library");
    private JMenu menuHelp = new JMenu("Help");
    private JMenu menuSubImport = new JMenu("Import");
    private JMenu menuSubExport = new JMenu("Export");
    private JMenuItem menuItemImportTapeBackup = new JMenuItem("Tape Save Recording (.wav)");
    private JMenuItem menuItemImportSysex = new JMenuItem("Binary Sysex (.syx)");
    private JMenuItem menuItemImportJep = new JMenuItem("Juno Editor Presets (.jep)");
    private JMenuItem menuItemExportWav = new JMenuItem("Active Library as Tape Save Recording (.wav)");
    private JMenuItem menuItemExportSyx = new JMenuItem("Active Patch as Binary Sysex (.syx)");
    private JMenuItem menuItemExportSyxLibrary = new JMenuItem("Active Library as Binary Sysex files (.syx)");
    private JMenuItem menuItemAbout = new JMenuItem("About");
    private JMenuItem menuItemPreferences = new JMenuItem("MIDI Settings");
    private JMenuItem menuItemWeb = new JMenuItem("Visit Web page");
    private JMenuItem menuItemLoadLibrary = new JMenuItem("Load Library");
    private JMenuItem menuItemSaveLibrary = new JMenuItem("Save Library");
    private JMenuItem menuItemSaveLibraryAs = new JMenuItem("Save Library as...");
    private JMenuItem menuItemNewLibrary = new JMenuItem("Create new Library");
    private JMenuItem menuItemMergeLibrary = new JMenuItem("Patches from other Library (.106)");
    private JMenuItem menuItemRenameLibrary = new JMenuItem("Rename Library");
    private JMenuItem menuItemCheckForDuplicates = new JMenuItem("Duplicate check");
    private JMenuItem menuItemExit = new JMenuItem("Exit");
    private JMenu menuView = new JMenu("View");
    private JRadioButtonMenuItem menuViewScale100 = new JRadioButtonMenuItem("100%");
    private JRadioButtonMenuItem menuViewScale125 = new JRadioButtonMenuItem("125%");
    private JRadioButtonMenuItem menuViewScale150 = new JRadioButtonMenuItem("150%");
    private JRadioButtonMenuItem menuViewScale175 = new JRadioButtonMenuItem("175%");

    public MainFrame(Core c) {
        super("j106 - Juno-106 Librarian");
        this.core = c;
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menuSystem);
        this.menuSystem.add(this.menuItemNewLibrary);
        this.menuSystem.add(this.menuItemLoadLibrary);
        this.menuSystem.add(this.menuItemSaveLibrary);
        this.menuSystem.add(this.menuItemSaveLibraryAs);
        this.menuSystem.add(this.menuItemRenameLibrary);
        this.menuSubImport.add(this.menuItemImportTapeBackup);
        this.menuSubImport.add(this.menuItemMergeLibrary);
        this.menuSubImport.add(this.menuItemImportJep);
        this.menuSubImport.add(this.menuItemImportSysex);
        this.menuSystem.add(this.menuSubImport);
        this.menuSubExport.add(this.menuItemExportSyx);
        this.menuSubExport.add(this.menuItemExportSyxLibrary);
        this.menuSubExport.add(this.menuItemExportWav);
        this.menuSystem.add(this.menuSubExport);
        this.menuSystem.addSeparator();
        this.menuSystem.add(this.menuItemPreferences);
        this.menuSystem.addSeparator();
        this.menuSystem.add(this.menuItemExit);
        this.menuView.add(this.menuViewScale100);
        this.menuView.add(this.menuViewScale125);
        this.menuView.add(this.menuViewScale150);
        this.menuView.add(this.menuViewScale175);
        ButtonGroup group = new ButtonGroup();
        group.add(this.menuViewScale100);
        group.add(this.menuViewScale125);
        group.add(this.menuViewScale150);
        group.add(this.menuViewScale175);
        this.menuViewScale125.setSelected(true);
        this.menuBar.add(this.menuView);
        this.menuViewScale100.addActionListener(this);
        this.menuViewScale125.addActionListener(this);
        this.menuViewScale150.addActionListener(this);
        this.menuViewScale175.addActionListener(this);
        this.menuBar.add(this.menuHelp);
        this.menuHelp.add(this.menuItemWeb);
        this.menuHelp.add(this.menuItemAbout);
        this.menuItemPreferences.addActionListener(this);
        this.menuItemExit.addActionListener(this);
        this.menuItemAbout.addActionListener(this);
        this.menuItemWeb.addActionListener(this);
        this.menuItemLoadLibrary.addActionListener(this);
        this.menuItemSaveLibrary.addActionListener(this);
        this.menuItemSaveLibraryAs.addActionListener(this);
        this.menuItemNewLibrary.addActionListener(this);
        this.menuItemMergeLibrary.addActionListener(this);
        this.menuItemRenameLibrary.addActionListener(this);
        this.menuItemCheckForDuplicates.addActionListener(this);
        this.menuItemImportTapeBackup.addActionListener(this);
        this.menuItemImportSysex.addActionListener(this);
        this.menuItemImportJep.addActionListener(this);
        this.menuItemExportSyx.addActionListener(this);
        this.menuItemExportSyxLibrary.addActionListener(this);
        this.menuItemExportWav.addActionListener(this);
        HashSet<AWTKeyStroke> rightKeyStrokeSet = new HashSet<AWTKeyStroke>();
        rightKeyStrokeSet.add(AWTKeyStroke.getAWTKeyStroke(39, 0));
        rightKeyStrokeSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        HashSet<AWTKeyStroke> leftKeyStrokeSet = new HashSet<AWTKeyStroke>();
        leftKeyStrokeSet.add(AWTKeyStroke.getAWTKeyStroke(37, 0));
        leftKeyStrokeSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        this.setFocusTraversalKeys(0, rightKeyStrokeSet);
        this.setFocusTraversalKeys(1, leftKeyStrokeSet);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.core.safeExit();
            }
        });
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String n;
            String s;
            int opt;
            if (e.getSource() == this.menuItemAbout) {
                this.core.aboutWindow.setLocation((this.core.mainFrame.getWidth() - this.core.aboutWindow.getWidth()) / 2 + (int)this.core.mainFrame.getLocation().getX(), (this.core.mainFrame.getHeight() - this.core.aboutWindow.getHeight()) / 2 + (int)this.core.mainFrame.getLocation().getY());
                this.core.aboutWindow.setVisible(true);
            }
            if (e.getSource() == this.menuItemWeb && (opt = JOptionPane.showConfirmDialog(this, "The web page http://www.jarvik7.net/juno-106 will be opened in your default web browser. Continue?", "Confirm browser launch", 0)) == 0) {
                try {
                    Desktop.getDesktop().browse(URI.create("http://www.jarvik7.net/juno-106/"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (e.getSource() == this.menuItemPreferences) {
                this.core.optionWindow.setLocation((this.core.mainFrame.getWidth() - this.core.optionWindow.getWidth()) / 2 + (int)this.core.mainFrame.getLocation().getX(), (this.core.mainFrame.getHeight() - this.core.optionWindow.getHeight()) / 2 + (int)this.core.mainFrame.getLocation().getY());
                this.core.optionWindow.setVisible(true);
            }
            if (e.getSource() == this.menuItemLoadLibrary) {
                this.core.loadLibraryDialogue();
                return;
            }
            if (e.getSource() == this.menuItemMergeLibrary) {
                ExtendedLibrary imported = null;
                imported = this.core.fileHandler.loadLibraryDialogueMerge();
                if (imported != null) {
                    imported.setName("Library file");
                }
                this.core.mergeWindow.mergeToActiveLibrary(imported);
            }
            if (e.getSource() == this.menuItemImportTapeBackup) {
                ExtendedLibrary imported = null;
                imported = this.core.wavFileImportHandler.importWavDialogue();
                if (imported == null) {
                    return;
                }
                this.core.mergeWindow.mergeToActiveLibrary(imported);
            }
            if (e.getSource() == this.menuItemExportWav) {
                this.core.exportLibraryToWav();
            }
            if (e.getSource() == this.menuItemExportSyx) {
                this.core.exportPatchToSysex();
            }
            if (e.getSource() == this.menuItemExportSyxLibrary) {
                this.core.exportLibraryToSysex();
            }
            if (e.getSource() == this.menuItemImportSysex || e.getSource() == this.menuItemImportJep) {
                ExtendedLibrary imported = null;
                if (e.getSource() == this.menuItemImportSysex) {
                    imported = this.core.binarySysexFileImportHandler.importMultipleSysexDialogue();
                    if (imported == null || imported.size() == 0) {
                        return;
                    }
                    imported.setName(".syx files");
                }
                if (e.getSource() == this.menuItemImportJep) {
                    imported = this.core.jepFileImportHandler.importMultipleJepDialogue();
                    if (imported == null || imported.size() == 0) {
                        return;
                    }
                    imported.setName(".jep files");
                }
                this.core.mergeWindow.mergeToActiveLibrary(imported);
            }
            if (e.getSource() == this.menuItemSaveLibraryAs) {
                this.core.saveLibraryDialogue();
                return;
            }
            if (e.getSource() == this.menuItemSaveLibrary) {
                this.core.saveLibrary();
                return;
            }
            if (e.getSource() == this.menuItemNewLibrary) {
                this.core.initNewLibrary();
                return;
            }
            if (e.getSource() == this.menuItemRenameLibrary && (s = JOptionPane.showInputDialog(this, "Name of Library", n = this.core.getLibraryName())) != null && !s.equals(n)) {
                this.core.setLibraryName(s);
            }
            if (e.getSource() == this.menuItemCheckForDuplicates) {
                boolean operationCancelled = this.core.patchChangesDialogue();
                if (operationCancelled) {
                    return;
                }
                int nrofUnique = this.core.getNrofUniquePatches();
                int nrofDuplicates = this.core.getLibrarySize() - nrofUnique;
                int option = -1;
                if (nrofUnique < this.core.getLibrarySize()) {
                    option = JOptionPane.showConfirmDialog(null, "There are " + nrofDuplicates + " duplicates in the library. Perform renaming?", "Naming options", 2);
                } else {
                    JOptionPane.showConfirmDialog(null, "There are no duplicates in the library.", "Naming options", -1);
                }
                if (option == 0) {
                    this.core.trimForDuplicates((int)Math.ceil(Math.log10(nrofUnique)));
                }
            }
            if (e.getSource() == this.menuItemExit) {
                this.core.safeExit();
            }
            if (e.getSource() == this.menuViewScale100) {
                this.core.setScale(1.0, true);
            }
            if (e.getSource() == this.menuViewScale125) {
                this.core.setScale(1.25, true);
            }
            if (e.getSource() == this.menuViewScale150) {
                this.core.setScale(1.5, true);
            }
            if (e.getSource() == this.menuViewScale175) {
                this.core.setScale(1.75, true);
            }
        }
    }

    public void setSaveEnabled(boolean enabled) {
        this.menuItemSaveLibrary.setEnabled(enabled);
    }

    public void setScale(double aScale) {
        if (aScale == 1.0) {
            this.menuViewScale100.setSelected(true);
        } else if (aScale == 1.25) {
            this.menuViewScale125.setSelected(true);
        } else if (aScale == 1.5) {
            this.menuViewScale150.setSelected(true);
        } else if (aScale == 1.75) {
            this.menuViewScale175.setSelected(true);
        }
    }
}

