/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;

public class MergeWindowLegacy
extends JDialog
implements ActionListener {
    Core core;
    ButtonGroup radios = new ButtonGroup();
    JRadioButton automatic = new JRadioButton("Automatically rename duplicates");
    JRadioButton manual = new JRadioButton("Manually rename duplicates");
    JRadioButton overwrite = new JRadioButton("Overwrite from source");
    JRadioButton discard = new JRadioButton("Discard from source");
    JLabel sourcename = new JLabel("");
    JLabel sourcenumber = new JLabel("(0 Patches)");
    JLabel targetname = new JLabel("");
    JLabel nrofConflicts = new JLabel("There are 12 name conflicts.");
    ButtonGroup nameradios = new ButtonGroup();
    JRadioButton renamesource = new JRadioButton("Rename in source");
    JRadioButton renametarget = new JRadioButton("Rename in target");
    JTextField name = new JTextField();
    JButton merge = new JButton("Merge");
    JButton cancel = new JButton("Cancel");
    ExtendedLibrary source;
    String currentNameMemory = null;

    public MergeWindowLegacy(Core c) {
        super(c.mainFrame, "Merge", true);
        Container pane = this.getContentPane();
        this.core = c;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("Options"));
        p.add(new JLabel("Import:"));
        p.add(this.sourcename);
        p.add(new JLabel(" "));
        p.add(new JLabel("Current Library:"));
        p.add(this.targetname);
        p.add(new JLabel(" "));
        p.add(this.nrofConflicts);
        p.add(this.automatic);
        p.add(this.overwrite);
        p.add(this.discard);
        this.radios.add(this.automatic);
        this.radios.add(this.overwrite);
        this.radios.add(this.discard);
        JPanel pb = new JPanel();
        pb.setLayout(new FlowLayout(1));
        pb.setAlignmentX(0.0f);
        pb.add(this.merge);
        pb.add(this.cancel);
        p.add(pb);
        pane.add(p);
        this.setResizable(true);
        this.pack();
        this.setVisible(false);
        this.automatic.setSelected(true);
        this.merge.addActionListener(this);
        this.cancel.addActionListener(this);
    }

    public void setInfo(String aSourceName, int nos, String aTargetName, int not, int aNrofConflicts) {
        this.sourcename.setText(aSourceName + " (" + Integer.toString(nos) + " patches)");
        this.targetname.setText(aTargetName + " (" + Integer.toString(not) + " patches)");
        if (aNrofConflicts > 0) {
            this.nrofConflicts.setText("Found " + aNrofConflicts + " name conflicts. Select how to handle:");
            this.automatic.setEnabled(true);
            this.overwrite.setEnabled(true);
            this.discard.setEnabled(true);
        } else {
            this.nrofConflicts.setText("No name conflicts found.");
            this.automatic.setEnabled(false);
            this.overwrite.setEnabled(false);
            this.discard.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.merge) {
            if (this.automatic.isSelected()) {
                this.core.mergeToLibrary(this.source, Core.MergeDuplicateOption.SMART);
            }
            if (this.overwrite.isSelected()) {
                this.core.mergeToLibrary(this.source, Core.MergeDuplicateOption.OVERWRITE);
            }
            if (this.discard.isSelected()) {
                this.core.mergeToLibrary(this.source, Core.MergeDuplicateOption.DISCARD);
            }
            this.source = null;
            this.setVisible(false);
            return;
        }
        if (e.getSource() == this.cancel) {
            this.source = null;
            this.setVisible(false);
        }
    }

    public void mergeToActiveLibrary(ExtendedLibrary aSource) {
        int opt;
        this.source = aSource;
        if (this.source == null) {
            return;
        }
        if (!this.core.hasPatchChanged() && this.core.isLibraryInit() && (opt = JOptionPane.showConfirmDialog(this.core.junoGui, "Current session has no useful changes (is init library). Init from import?", "Import option", 0)) == 0) {
            this.core.mergeToLibrary(this.source, Core.MergeDuplicateOption.INIT_FROM_IMPORTED_LIBRARY);
            return;
        }
        int[] tmp = this.core.compareToActiveLibrary(this.source);
        if (this.source.size() != 0) {
            if (tmp[1] == 0) {
                this.core.mergeToLibrary(this.source, Core.MergeDuplicateOption.DISCARD);
                return;
            }
            this.setInfo(this.source.getName(), this.source.size(), this.core.getLibraryName(), this.core.getLibrarySize(), tmp[1]);
            this.pack();
            this.setLocation((this.core.mainFrame.getWidth() - this.getWidth()) / 2 + (int)this.core.mainFrame.getLocation().getX(), (this.core.mainFrame.getHeight() - this.getHeight()) / 2 + (int)this.core.mainFrame.getLocation().getY());
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.core.mainFrame, "Loaded Library is empty. Merge operation cancelled.", "Merge error", 0);
            this.source = null;
        }
    }
}

