/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;
import javax.swing.JPanel;
import org.bjno.j106.gui.Core;

class MidiKeyboard
extends JPanel {
    private int width = 432;
    private int height = 56;
    private static int WIDTH_WHITE_KEY = 12;
    private static int WIDTH_BLACK_KEY = 8;
    private static int HEIGHT_WHITE_KEY = 56;
    private static int HEIGHT_BLACK_KEY = 36;
    private static int MARGIN_LEFT = 0;
    private static int MARGIN_TOP = 0;
    private static int OCTAVE_MAX = 4;
    private static int OCTAVE_MIN = 1;
    private MidiKey[] keyList = new MidiKey[100];
    private Core core;
    private String[] conversion = new String[]{"Z", "S", "X", "D", "C", "V", "G", "B", "H", "N", "J", "M", "Q", "2", "W", "3", "E", "R", "5", "T", "6", "Y", "7", "U", "I", "9", "O", "0", "P", "Comma"};
    private ArrayList<MidiKey> activeKeys = new ArrayList(6);
    private MidiKey playing = null;
    private MidiKey abcRootKey;
    private KeyListener internalKeyListener = new InternalKeyListener();
    private boolean mouseEnabled = true;
    private boolean abcEnabled = true;
    private int octave;
    private int markerSize = 4;

    public void scale(double aScale) {
        this.width = (int)((double)this.width * aScale);
        this.height = (int)((double)this.height * aScale);
        Rectangle b = this.getBounds();
        this.setBounds((int)(b.getX() * aScale), (int)(b.getY() * aScale), this.width, this.height);
        int i = 0;
        while (this.keyList[i] != null) {
            this.keyList[i].scale(aScale);
            ++i;
        }
        this.abcRootKey.scale(aScale);
        this.markerSize = (int)((double)this.markerSize * aScale);
        this.repaint();
    }

    public KeyListener getKeyListener() {
        return this.internalKeyListener;
    }

    public MidiKeyboard(Core aCore, int anOctave) {
        this.setBounds(0, 0, this.width, this.height);
        this.setLayout(null);
        this.setOpaque(false);
        this.setFocusable(true);
        this.core = aCore;
        this.setVisible(true);
        this.octave = anOctave;
        int keyCounter = 0;
        for (int i = 0; i < 36; ++i) {
            this.keyList[keyCounter] = new MidiKey(MARGIN_LEFT + i * WIDTH_WHITE_KEY, MARGIN_TOP, WIDTH_WHITE_KEY, HEIGHT_WHITE_KEY, Color.WHITE, keyCounter + 36);
            ++keyCounter;
            if (i % 7 == 2 || i % 7 == 6) continue;
            this.keyList[keyCounter] = new MidiKey(MARGIN_LEFT + 8 + i * WIDTH_WHITE_KEY, MARGIN_TOP, WIDTH_BLACK_KEY, HEIGHT_BLACK_KEY, Color.BLACK, keyCounter + 36);
            ++keyCounter;
        }
        this.abcRootKey = new MidiKey(MARGIN_LEFT + 7 * (this.octave - 1) * WIDTH_WHITE_KEY, MARGIN_TOP, WIDTH_WHITE_KEY, HEIGHT_WHITE_KEY, Color.WHITE, 60);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MidiKeyboard.this.mouseEnabled) {
                    MidiKey result1 = null;
                    int i = 0;
                    while (MidiKeyboard.this.keyList[i] != null) {
                        if (MidiKeyboard.this.keyList[i].contains(e.getX(), e.getY()) && MidiKeyboard.this.keyList[i].inFrontOf(result1)) {
                            result1 = MidiKeyboard.this.keyList[i];
                        }
                        ++i;
                    }
                    if (MidiKeyboard.this.activeKeys.contains(result1)) {
                        return;
                    }
                    if (result1 == null) {
                        return;
                    }
                    ShortMessage shortMessage = new ShortMessage();
                    try {
                        shortMessage.setMessage(144, MidiKeyboard.this.core.getMidiChannel(), result1.keyNr, 60);
                    }
                    catch (Exception exzc) {
                        System.out.println(exzc.toString());
                    }
                    MidiKeyboard.this.core.sendMidiMessage(shortMessage);
                    MidiKeyboard.this.playing = result1;
                    MidiKeyboard.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MidiKeyboard.this.playing == null || MidiKeyboard.this.activeKeys.contains(MidiKeyboard.this.playing)) {
                    return;
                }
                ShortMessage shortMessage = new ShortMessage();
                try {
                    shortMessage.setMessage(128, MidiKeyboard.this.core.getMidiChannel(), ((MidiKeyboard)MidiKeyboard.this).playing.keyNr, 60);
                }
                catch (Exception exzc) {
                    System.out.println(exzc.toString());
                }
                MidiKeyboard.this.core.sendMidiMessage(shortMessage);
                MidiKeyboard.this.playing = null;
                MidiKeyboard.this.repaint();
            }
        });
    }

    private void updateRootKey(int anOctave) {
        this.octave = anOctave;
        this.abcRootKey = new MidiKey(MARGIN_LEFT + 7 * (this.octave - 1) * this.abcRootKey.width, MARGIN_TOP, this.abcRootKey.width, this.abcRootKey.height, Color.WHITE, 60);
        this.allNotesOff();
        this.repaint();
    }

    public boolean increaseOctave() {
        if (this.octave < OCTAVE_MAX) {
            ++this.octave;
            this.updateRootKey(this.octave);
        }
        return this.octave != OCTAVE_MAX;
    }

    public boolean decreaseOctave() {
        if (this.octave > OCTAVE_MIN) {
            --this.octave;
            this.updateRootKey(this.octave);
        }
        return this.octave != OCTAVE_MIN;
    }

    public void setOctave(int i) {
        if (i < OCTAVE_MIN) {
            i = OCTAVE_MIN;
        }
        if (i > OCTAVE_MAX) {
            i = OCTAVE_MAX;
        }
        this.octave = i;
        this.updateRootKey(this.octave);
    }

    public int getOctave() {
        return this.octave;
    }

    public boolean canIncreaseOctave() {
        return this.octave < OCTAVE_MAX;
    }

    public boolean canDecreaseOctave() {
        return this.octave > OCTAVE_MIN;
    }

    public void setMouseEnabled(boolean b) {
        this.mouseEnabled = b;
    }

    public boolean isMouseEnabled() {
        return this.mouseEnabled;
    }

    public void setAbcEnabled(boolean b) {
        this.abcEnabled = b;
    }

    public boolean isAbcEnabled() {
        return this.abcEnabled;
    }

    public void allNotesOff() {
        if (this.playing != null) {
            ShortMessage shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(128, this.core.getMidiChannel(), this.playing.keyNr, 60);
            }
            catch (Exception exzc) {
                System.out.println(exzc.toString());
            }
            this.core.sendMidiMessage(shortMessage);
            this.playing = null;
        }
        for (MidiKey midiKey : this.activeKeys) {
            ShortMessage m = new ShortMessage();
            try {
                m.setMessage(128, this.core.getMidiChannel(), midiKey.keyNr, 60);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            this.core.sendMidiMessage(m);
        }
        this.activeKeys.clear();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.gray);
        Dimension d = this.abcRootKey.returnPaintCoordinate();
        g.fillOval(d.width, d.height, this.markerSize, this.markerSize);
        if (this.activeKeys.size() != 0) {
            g.setColor(Color.red);
            for (MidiKey midiKey : this.activeKeys) {
                if (midiKey == null) continue;
                d = midiKey.returnPaintCoordinate();
                g.fillOval(d.width, d.height, this.markerSize, this.markerSize);
            }
        }
        if (this.playing != null) {
            g.setColor(Color.red);
            Dimension dm = this.playing.returnPaintCoordinate();
            g.fillOval(dm.width, dm.height, this.markerSize, this.markerSize);
        }
    }

    public void setBackground(Image bg) {
    }

    public void pitchBend(int aValue) {
        ShortMessage m = new ShortMessage();
        try {
            m.setMessage(224, this.core.getMidiChannel(), 0, (byte)aValue);
            this.core.sendMidiMessage(m);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    public void modulation(int aValue) {
        ShortMessage m = new ShortMessage();
        try {
            m.setMessage(176, this.core.getMidiChannel(), 1, (byte)aValue);
            this.core.sendMidiMessage(m);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    private void midiKeyDown(int note) {
        if (this.abcEnabled) {
            if (this.playing == this.keyList[note - 36]) {
                return;
            }
            if (note > 96) {
                return;
            }
            if (!this.activeKeys.contains(this.keyList[note - 36])) {
                ShortMessage m = new ShortMessage();
                try {
                    m.setMessage(144, this.core.getMidiChannel(), note, 60);
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                this.core.sendMidiMessage(m);
                this.activeKeys.add(this.keyList[note - 36]);
                this.repaint();
            }
        }
    }

    private void midiKeyUp(int note) {
        if (this.playing == this.keyList[note - 36]) {
            return;
        }
        if (note > 96) {
            return;
        }
        if (this.activeKeys.contains(this.keyList[note - 36])) {
            ShortMessage m = new ShortMessage();
            try {
                m.setMessage(128, this.core.getMidiChannel(), note, 60);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            this.core.sendMidiMessage(m);
            this.activeKeys.remove(this.keyList[note - 36]);
            this.repaint();
        }
    }

    private int returnNote(String s) {
        int note = -1;
        for (int i = 0; i < this.conversion.length; ++i) {
            if (!s.equals(this.conversion[i])) continue;
            note = i + 12 * this.octave + 24;
        }
        if (s == "Comma") {
            note = 12 + 12 * this.octave + 24;
        }
        return note;
    }

    private class MidiKey
    extends Rectangle {
        int keyNr;
        Color col;

        public MidiKey(int w, int h, int width, int height, Color c, int k) {
            super(w, h, width, height);
            this.keyNr = k;
            this.col = c;
        }

        public Dimension returnPaintCoordinate() {
            if (this.col == Color.white) {
                return new Dimension(this.x + (this.width - MidiKeyboard.this.markerSize) / 2, this.y + this.height - 2 * MidiKeyboard.this.markerSize);
            }
            return new Dimension(this.x + (this.width - MidiKeyboard.this.markerSize) / 2, this.y + this.height - 2 * MidiKeyboard.this.markerSize);
        }

        @Override
        public String toString() {
            return "Key nr: " + this.keyNr + " color: " + this.col + " x: " + this.x;
        }

        public boolean inFrontOf(MidiKey k) {
            if (k == null) {
                return true;
            }
            return this.col == Color.BLACK && k.col == Color.WHITE;
        }

        public void scale(double aScale) {
            this.x = (int)((double)this.x * aScale);
            this.y = (int)((double)this.y * aScale);
            this.width = (int)((double)this.width * aScale);
            this.height = (int)((double)this.height * aScale);
        }
    }

    private class InternalKeyListener
    extends KeyAdapter {
        private InternalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            String key = KeyEvent.getKeyText(e.getKeyCode());
            int note = MidiKeyboard.this.returnNote(key);
            if (note != -1) {
                MidiKeyboard.this.midiKeyDown(note);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            String key = KeyEvent.getKeyText(e.getKeyCode());
            int note = MidiKeyboard.this.returnNote(key);
            if (note != -1) {
                MidiKeyboard.this.midiKeyUp(note);
            }
        }
    }
}

