/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.bjno.j106.gui.Core;
import org.bjno.jcustomgui.JCustomPanel;

public class MidiMonitor
extends JDialog {
    private Vector<String> buffer = new Vector();
    private JLabel l1;
    private JLabel l2;
    private JLabel l3;
    private JLabel l4;
    private JLabel l5;
    Core core;
    boolean hasBeenShowed = false;
    ArrayList<JLabel> labels;

    public MidiMonitor(Core c) {
        super(c.mainFrame, "Juno-106 Midi Monitor", false);
        this.buffer.add(new String(""));
        this.buffer.add(new String(""));
        this.buffer.add(new String(""));
        this.buffer.add(new String(""));
        this.buffer.add(new String(""));
        this.core = c;
        this.createAndShowGui();
        this.addWindowListener(new WindowTracer());
        this.setDefaultCloseOperation(0);
    }

    public void print(String s) {
        this.buffer.add(0, s);
        this.l1.setText(this.buffer.get(0));
        this.l2.setText(this.buffer.get(1));
        this.l3.setText(this.buffer.get(2));
        this.l4.setText(this.buffer.get(3));
        this.l5.setText(this.buffer.get(4));
        this.buffer.remove(5);
    }

    public void monitor(MidiMessage m, String s) {
        if (this.isVisible()) {
            String dump = s;
            byte[] b = m.getMessage();
            for (int k = 0; k < b.length; ++k) {
                int tmp = b[k];
                if (tmp < 0) {
                    tmp += 256;
                }
                dump = dump + " " + this.syntaxInteger(tmp);
            }
            this.print(dump);
        }
    }

    private String syntaxInteger(int i) {
        String tmp = Integer.toHexString(i);
        if (tmp.length() == 1) {
            tmp = "0" + tmp;
        }
        return tmp;
    }

    public void createAndShowGui() {
        Image bg = this.core.getImage("midimon.png");
        JCustomPanel p = new JCustomPanel(539, 72);
        p.setBackground(bg);
        this.getContentPane().add(p);
        Font font = new Font("Monospaced", 0, 11);
        Color fg1 = new Color(204, 0, 17);
        Color fg2 = new Color(174, 0, 17);
        EmptyBorder border = new EmptyBorder(0, 0, 0, 0);
        this.l1 = new JLabel("");
        this.l2 = new JLabel("");
        this.l3 = new JLabel("");
        this.l4 = new JLabel("");
        this.l5 = new JLabel("");
        this.l1.setBorder(border);
        this.l2.setBorder(border);
        this.l3.setBorder(border);
        this.l4.setBorder(border);
        this.l5.setBorder(border);
        this.l1.setFont(font);
        this.l2.setFont(font);
        this.l3.setFont(font);
        this.l4.setFont(font);
        this.l5.setFont(font);
        this.l1.setForeground(fg1);
        this.l2.setForeground(fg1);
        this.l3.setForeground(fg1);
        this.l4.setForeground(fg1);
        this.l5.setForeground(fg1);
        JLabel tab = new JLabel("PRT 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23");
        tab.setBorder(border);
        tab.setFont(font);
        tab.setForeground(fg2);
        p.add(tab, 5, 6, 550, 9);
        p.add(this.l1, 5, 17, 540, 9);
        p.add(this.l2, 5, 27, 540, 9);
        p.add(this.l3, 5, 37, 540, 9);
        p.add(this.l4, 5, 47, 540, 9);
        p.add(this.l5, 5, 57, 540, 9);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.pack();
        this.print("Juno-106 Librarian V3.0");
    }

    class WindowTracer
    extends WindowAdapter {
        WindowTracer() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MidiMonitor.this.setVisible(true);
        }
    }
}

