/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.bjno.j106.gui.Core;

public class OptionWindow
extends JDialog
implements ActionListener {
    Core core;
    public JCheckBox midithrurouting = new JCheckBox("Route MIDI in to MIDI out");
    public JComboBox<String> midiin;
    public JComboBox<String> midiout;
    public JComboBox<Integer> midiChannel;
    public JComboBox<String> midithru;
    public JComboBox<String> warning;
    JButton apply = new JButton("Close");

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public OptionWindow(Core c) {
        super(c.mainFrame, "Options", true);
        int i;
        Container pane = this.getContentPane();
        pane.setLayout(new BoxLayout(pane, 1));
        this.core = c;
        JPanel midiSettings = new JPanel();
        midiSettings.setLayout(new BoxLayout(midiSettings, 1));
        midiSettings.setBorder(new TitledBorder("MIDI settings"));
        midiSettings.add(new JLabel("MIDI input port"));
        String[] midiIns = this.core.getMidiInPortNames();
        midiSettings.setAlignmentX(0.0f);
        this.midiin = new JComboBox();
        this.midiin.setAlignmentX(0.0f);
        this.midiin.addItem("---");
        for (int i2 = 0; i2 < midiIns.length; ++i2) {
            this.midiin.addItem(midiIns[i2]);
        }
        midiSettings.add(this.midiin);
        this.midiin.addActionListener(this);
        midiSettings.add(Box.createRigidArea(new Dimension(5, 5)));
        String[] midiOuts = this.core.getMidiOutPortNames();
        this.midiout = new JComboBox();
        this.midiout.setAlignmentX(0.0f);
        midiSettings.add(new JLabel("MIDI output port"));
        this.midiout.addItem("---");
        for (i = 0; i < midiOuts.length; ++i) {
            this.midiout.addItem(midiOuts[i]);
        }
        midiSettings.add(this.midiout);
        this.midiout.addActionListener(this);
        midiSettings.add(Box.createRigidArea(new Dimension(5, 5)));
        this.midiChannel = new JComboBox();
        this.midiChannel.setAlignmentX(0.0f);
        midiSettings.add(new JLabel("MIDI Channel"));
        for (i = 1; i <= 16; ++i) {
            this.midiChannel.addItem(i);
        }
        midiSettings.add(this.midiChannel);
        this.midiChannel.addActionListener(this);
        midiSettings.add(Box.createRigidArea(new Dimension(5, 5)));
        midiSettings.add(new JLabel("MIDI thru port"));
        midiSettings.add(this.midithrurouting);
        this.midithrurouting.addActionListener(this);
        this.midithru = new JComboBox();
        this.midithru.setAlignmentX(0.0f);
        this.midithru.addItem("---");
        for (i = 0; i < midiOuts.length; ++i) {
            this.midithru.addItem(midiOuts[i]);
        }
        midiSettings.add(this.midithru);
        this.midithru.addActionListener(this);
        midiSettings.add(Box.createRigidArea(new Dimension(5, 5)));
        midiSettings.add(this.apply);
        pane.add(midiSettings);
        this.apply.addActionListener(this);
        this.pack();
        this.setVisible(false);
        this.setResizable(false);
        JPanel gp = (JPanel)this.getGlassPane();
        gp.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newname;
        if (e.getSource() == this.apply) {
            this.setVisible(false);
        }
        if (e.getSource() == this.midiChannel) {
            this.core.setMidiChannel((Integer)this.midiChannel.getSelectedItem() - 1);
        }
        if (e.getSource() == this.midiout) {
            newname = (String)this.midiout.getSelectedItem();
            try {
                if (!newname.equals(this.core.getMidiThruPort())) {
                    this.core.setMidiOutPort(newname);
                } else {
                    this.core.disableMidiOutPort();
                    this.midiout.setSelectedItem("---");
                    JOptionPane.showMessageDialog(this, "MIDI out device can not be set to the same port as MIDI thru.\n\nInstead, choose the \"Route MIDI in to MIDI out\" option.", "MIDI unavailible exception", 0);
                }
            }
            catch (MidiUnavailableException exception) {
                this.core.disableMidiOutPort();
                this.midiout.setSelectedItem("---");
                JOptionPane.showMessageDialog(this, "MIDI out device " + newname + " could not be chosen.\nThe device might be in use with another application.", "MIDI unavailible exception", 0);
            }
        }
        if (e.getSource() == this.midiin) {
            newname = (String)this.midiin.getSelectedItem();
            try {
                this.core.setMidiInPort(newname);
            }
            catch (MidiUnavailableException exception) {
                this.core.disableMidiInPort();
                this.midiin.setSelectedItem("---");
                JOptionPane.showMessageDialog(this, "MIDI in device " + newname + " could not be chosen.\nThe device might be in use with another application.", "MIDI unavailible exception", 0);
            }
        }
        if (e.getSource() == this.midithrurouting) {
            if (this.midithrurouting.isSelected()) {
                this.midithru.setEnabled(false);
                this.core.disableMidiThruPort();
                this.core.setMidiThruRouting(true);
            } else {
                this.midithru.setEnabled(true);
                this.core.setMidiThruRouting(false);
                this.midithru.setSelectedItem(this.midithru.getSelectedItem());
            }
        }
        if (e.getSource() == this.midithru) {
            newname = (String)this.midithru.getSelectedItem();
            this.core.setMidiThruRouting(false);
            try {
                if (newname.equals("---")) {
                    this.core.disableMidiThruPort();
                } else if (!newname.equals(this.core.getMidiOutPort())) {
                    this.core.setMidiThruPort(newname);
                } else {
                    this.core.disableMidiThruPort();
                    this.midithru.setSelectedItem("---");
                    JOptionPane.showMessageDialog(this, "MIDI thru device can not be set to the same port as MIDI out.\n\n Instead, choose the \"Route MIDI in to MIDI out\" option.", "MIDI unavailible exception", 0);
                }
            }
            catch (MidiUnavailableException exception) {
                this.core.disableMidiThruPort();
                this.midithru.setSelectedItem("---");
                JOptionPane.showMessageDialog(this.core.mainFrame, "MIDI thru device " + newname + " could not be chosen.\nThe device might be in use with another application.", "MIDI unavailible exception", 0);
            }
        }
    }
}

