/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.waves.J106Decoder;
import org.bjno.j106.waves.J106Encoder;
import org.bjno.jcustomgui.JCustomButton;
import org.bjno.jcustomgui.JCustomEvent;
import org.bjno.jcustomgui.JCustomIndicator;
import org.bjno.jcustomgui.JCustomListener;
import org.bjno.jcustomgui.JCustomPanel;

public class TapeWindow
extends JDialog
implements JCustomListener,
J106Decoder.DecoderStateListener {
    JPanel innerPanel;
    Core core;
    JCustomButton recordButton;
    JCustomButton stopButton;
    JCustomButton playButton;
    JCustomButton saveButton;
    JCustomButton resetButton;
    JTextField bankName;
    J106Decoder decoder;
    J106Encoder encoder;
    Thread decodingThread = null;
    Thread encodingThread = null;
    Thread monitorThread = null;
    boolean decoding = false;
    double[] vuMeterThresholds = new double[]{-40.0, -20.0, -10.0, -5.0, -3.0, -0.5};
    ArrayList<JCustomIndicator> vuMeter;
    JLabel vuMeterText;
    int numberOfVuSteps = 6;
    ArrayList<JCustomIndicator> statusMeter;
    int numberOfStatusSteps = 4;
    double test = -45.0;
    double add = 1.0;

    private void updateVuMeter(double value) {
        int i;
        int onSteps = 0;
        for (i = 0; i < this.vuMeterThresholds.length && value >= this.vuMeterThresholds[i]; ++i) {
            onSteps = i + 1;
        }
        for (i = 0; i < this.numberOfVuSteps; ++i) {
            if (this.vuMeter.get(i * 2).getValue() == i < onSteps) continue;
            this.vuMeter.get(i * 2).setValue(i < onSteps);
            this.vuMeter.get(i * 2 + 1).setValue(i < onSteps);
        }
    }

    private void updateStatusMeter(double value) {
        int onStep = (int)((double)this.numberOfStatusSteps * value);
        for (int i = 0; i < this.numberOfStatusSteps; ++i) {
            this.statusMeter.get(i).setValue(i == onStep);
        }
    }

    TapeWindow(Core aCore) {
        super((Frame)aCore.mainFrame, true);
        this.core = aCore;
        this.decoder = new J106Decoder(this, true);
        Font font = new Font("Monospaced", 0, 10);
        Color lightGreyText = new Color(206, 206, 206);
        Color lightGreenVuMeter = new Color(243, 252, 233);
        Color mediumGreyStatus = new Color(142, 140, 151);
        HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
        attributes.put(TextAttribute.FAMILY, "Helvetica");
        attributes.put(TextAttribute.TRACKING, 0.03);
        attributes.put(TextAttribute.FOREGROUND, lightGreyText);
        attributes.put(TextAttribute.WIDTH, 1.11);
        attributes.put(TextAttribute.SIZE, 14.4);
        attributes.put(TextAttribute.FOREGROUND, lightGreyText);
        Font fontLogo = font.deriveFont(attributes);
        attributes.put(TextAttribute.SIZE, 10.8);
        attributes.put(TextAttribute.FOREGROUND, lightGreyText);
        Font fontManButtons = font.deriveFont(attributes);
        attributes.put(TextAttribute.SIZE, 9.0);
        attributes.put(TextAttribute.FOREGROUND, lightGreyText);
        Font fontSmallButtons = font.deriveFont(attributes);
        attributes.put(TextAttribute.SIZE, 9.0);
        attributes.put(TextAttribute.FOREGROUND, mediumGreyStatus);
        Font fontStatus = font.deriveFont(attributes);
        attributes.put(TextAttribute.SIZE, 10.8);
        attributes.put(TextAttribute.FOREGROUND, lightGreenVuMeter);
        Font fontVuMeter = font.deriveFont(attributes);
        attributes.put(TextAttribute.SIZE, 8.1);
        attributes.put(TextAttribute.FOREGROUND, lightGreenVuMeter);
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        Font fontVuMeterText = font.deriveFont(attributes);
        JLabel logo = new JLabel("JUNO-106 TAPE DECODER");
        logo.setFont(fontLogo);
        logo.setForeground(Color.BLUE);
        JLabel record = new JLabel("RECORD", 0);
        record.setFont(fontManButtons);
        JLabel stop = new JLabel("STOP", 0);
        stop.setFont(fontManButtons);
        JLabel play = new JLabel("PLAY", 0);
        play.setFont(fontManButtons);
        JLabel save = new JLabel("IMPORT", 0);
        save.setFont(fontSmallButtons);
        JLabel reset = new JLabel("RESET", 0);
        reset.setFont(fontSmallButtons);
        JLabel peakLevelText = new JLabel("PEAK LEVEL METER");
        peakLevelText.setFont(fontVuMeterText);
        JLabel projectNameText = new JLabel("BANK NAME");
        projectNameText.setFont(fontVuMeterText);
        this.bankName = new JTextField("My Juno-106");
        this.bankName.setFont(fontVuMeter);
        this.bankName.setOpaque(false);
        this.bankName.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.bankName.setCaretColor(lightGreenVuMeter);
        this.bankName.setCaretPosition(this.bankName.getText().length());
        JLabel statusTag = new JLabel("STATUS");
        statusTag.setFont(fontStatus);
        JLabel status1 = new JLabel("SYNC");
        status1.setFont(fontStatus);
        JLabel status2 = new JLabel("DATA");
        status2.setFont(fontStatus);
        JLabel status3 = new JLabel("READY");
        status3.setFont(fontStatus);
        JLabel status4 = new JLabel("ERROR");
        status4.setFont(fontStatus);
        Container container = this.getContentPane();
        JCustomPanel p = new JCustomPanel(472, 282);
        p.setBackground(this.core.getImage("tapeload.png"));
        p.add(logo, 31, 23, 250, 30);
        p.add(record, 124, 228, 97, 15);
        p.add(stop, 225, 228, 97, 15);
        p.add(play, 326, 228, 97, 15);
        p.add(save, 37, 195, 50, 15);
        p.add(reset, 37, 230, 50, 15);
        p.add(statusTag, 304, 68, 50, 15);
        p.add(status1, 391, 68, 50, 15);
        p.add(status2, 391, 91, 50, 15);
        p.add(status3, 391, 114, 50, 15);
        p.add(status4, 391, 137, 50, 15);
        JLabel dB0 = new JLabel("dB");
        dB0.setFont(fontVuMeter);
        JLabel dB1 = new JLabel("-40");
        dB1.setFont(fontVuMeter);
        JLabel dB2 = new JLabel("-20");
        dB2.setFont(fontVuMeter);
        JLabel dB3 = new JLabel("-10");
        dB3.setFont(fontVuMeter);
        JLabel dB4 = new JLabel("-5");
        dB4.setFont(fontVuMeter);
        JLabel dB5 = new JLabel("-3");
        dB5.setFont(fontVuMeter);
        JLabel dB6 = new JLabel("0");
        dB6.setFont(fontVuMeter);
        p.add(dB0, 92, 123, 250, 30);
        p.add(dB1, 113, 123, 250, 30);
        p.add(dB2, 133, 123, 250, 30);
        p.add(dB3, 153, 123, 250, 30);
        p.add(dB4, 177, 123, 250, 30);
        p.add(dB5, 196, 123, 250, 30);
        p.add(dB6, 219, 123, 250, 30);
        p.add(peakLevelText, 113, 112, 250, 15);
        p.add(projectNameText, 113, 82, 250, 15);
        p.add(this.bankName, 113, 98, 250, 15);
        Image btnGreyNormal = this.core.getImage("button_tape_stop.png");
        Image btnGreyActive = this.core.getImage("button_tape_stop_active.png");
        Image btnRecNormal = this.core.getImage("button_tape_rec.png");
        Image btnRecActive = this.core.getImage("button_tape_rec_active.png");
        Image btnPlayNormal = this.core.getImage("button_tape_play.png");
        Image btnPlayActive = this.core.getImage("button_tape_play_active.png");
        Image btnSaveActive = this.core.getImage("button_tape_green_active.png");
        Image btnReset = this.core.getImage("button_tape_blue.png");
        this.recordButton = new JCustomButton(ComponentId.k_button_record, btnRecNormal, btnRecActive, 97, 65);
        this.recordButton.setFocusable(false);
        this.recordButton.addGuiListener(this);
        p.add((Component)this.recordButton, 124, 185);
        this.stopButton = new JCustomButton(ComponentId.k_button_stop, btnGreyNormal, btnGreyActive, 97, 65);
        this.stopButton.setFocusable(false);
        this.stopButton.addGuiListener(this);
        p.add((Component)this.stopButton, 225, 185);
        this.playButton = new JCustomButton(ComponentId.k_button_play, btnPlayNormal, btnPlayActive, 97, 65);
        this.playButton.setFocusable(false);
        this.playButton.addGuiListener(this);
        p.add((Component)this.playButton, 326, 185);
        this.saveButton = new JCustomButton(ComponentId.k_button_save, btnSaveActive, btnSaveActive, 50, 30);
        this.saveButton.setFocusable(false);
        this.saveButton.addGuiListener(this);
        p.add((Component)this.saveButton, 37, 185);
        this.resetButton = new JCustomButton(ComponentId.k_button_reset, btnReset, btnReset, 50, 30);
        this.resetButton.setFocusable(false);
        this.resetButton.addGuiListener(this);
        p.add((Component)this.resetButton, 37, 220);
        this.vuMeter = new ArrayList();
        for (int i = 0; i < this.numberOfVuSteps; ++i) {
            this.vuMeter.add(new JCustomIndicator(this.core.getImage("vu_low_on.png"), this.core.getImage("vu_low_off.png"), 20, 8));
            this.vuMeter.add(new JCustomIndicator(this.core.getImage("vu_low_on.png"), this.core.getImage("vu_low_off.png"), 20, 8));
            p.add((Component)this.vuMeter.get(i * 2), 112 + i * 20, 125);
            p.add((Component)this.vuMeter.get(i * 2 + 1), 112 + i * 20, 143);
        }
        this.statusMeter = new ArrayList();
        this.statusMeter.add(new JCustomIndicator(this.core.getImage("indicator_status_on_yellow.png"), this.core.getImage("indicator_status_off.png"), 17, 10));
        p.add((Component)this.statusMeter.get(0), 363, 68);
        this.statusMeter.add(new JCustomIndicator(this.core.getImage("indicator_status_on_yellow.png"), this.core.getImage("indicator_status_off.png"), 17, 10));
        p.add((Component)this.statusMeter.get(1), 363, 91);
        this.statusMeter.add(new JCustomIndicator(this.core.getImage("indicator_status_on_green.png"), this.core.getImage("indicator_status_off.png"), 17, 10));
        p.add((Component)this.statusMeter.get(2), 363, 114);
        this.statusMeter.add(new JCustomIndicator(this.core.getImage("indicator_status_on_red.png"), this.core.getImage("indicator_status_off.png"), 17, 10));
        p.add((Component)this.statusMeter.get(3), 363, 137);
        this.init();
        this.setUndecorated(false);
        container.add(p);
        this.pack();
        this.setVisible(false);
        this.setResizable(false);
    }

    public void init() {
        this.updateStatusMeter(-1.0);
        this.updateVuMeter(-100.0);
        this.recordButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.playButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.resetButton.setEnabled(true);
    }

    @Override
    public void processEvent(JCustomEvent e) {
        ComponentId id = (ComponentId)e.getSourceId();
        if (id == ComponentId.k_button_record) {
            this.decoder.initDecoderStates();
            this.decoder.isStarted = true;
            this.decoding = true;
            this.updateStatusMeter(-1.0);
            this.decodingThread = new Thread(this.decoder);
            this.decodingThread.start();
            this.recordButton.setEnabled(false);
            this.recordButton.setPushed(true);
            this.stopButton.setEnabled(true);
            this.monitorThread = new Thread(new GuiUpdater());
            this.monitorThread.start();
        }
        if (id == ComponentId.k_button_stop) {
            this.decoder.isStarted = false;
            this.decoding = false;
            this.updateVuMeter(-100.0);
            this.recordButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        if (id == ComponentId.k_button_play) {
            this.encoder = new J106Encoder(true);
            this.encoder.setLibrary(this.decoder.getReceivedLibrary("", "", true), true);
            this.encoder.run();
        }
        if (id == ComponentId.k_button_save) {
            ExtendedLibrary library = this.decoder.getReceivedLibrary("CHANGE", this.bankName.getText(), true);
            library.setName("Tape interface data");
            this.setVisible(false);
            this.core.mergeWindow.mergeToActiveLibrary(library);
        }
        if (id == ComponentId.k_button_reset) {
            // empty if block
        }
    }

    @Override
    public void notifyStateChange() {
        if (this.decoding) {
            if (this.decoder.state.equals((Object)J106Decoder.DecoderState.SYNC_TONE_NOT_FOUND)) {
                System.out.println("WINDOW SHOWS: " + (Object)((Object)this.decoder.state));
                this.updateStatusMeter(-1.0);
            }
            if (this.decoder.state.equals((Object)J106Decoder.DecoderState.SYNC_TONE_FOUND)) {
                System.out.println("WINDOW SHOWS: " + (Object)((Object)this.decoder.state));
                this.updateStatusMeter(0.0);
            }
            if (this.decoder.state.equals((Object)J106Decoder.DecoderState.ATTEMPT_DECODING)) {
                System.out.println("WINDOW SHOWS: " + (Object)((Object)this.decoder.state));
                this.updateStatusMeter(0.25);
            }
            if (this.decoder.state.equals((Object)J106Decoder.DecoderState.SUCCESSFUL_DECODING)) {
                System.out.println("WINDOW SHOWS: " + (Object)((Object)this.decoder.state));
                this.updateStatusMeter(0.5);
                this.decoder.isStarted = false;
                this.decoding = false;
                this.updateVuMeter(-100.0);
                this.recordButton.setEnabled(true);
                this.stopButton.setEnabled(false);
                this.playButton.setEnabled(true);
                this.saveButton.setEnabled(true);
            }
            if (this.decoder.state.equals((Object)J106Decoder.DecoderState.FAILED_BYTE_FORMAT_ERROR) || this.decoder.state.equals((Object)J106Decoder.DecoderState.FAILED_CHECKSUM_ERROR) || this.decoder.state.equals((Object)J106Decoder.DecoderState.FAILED_HEADER_ERROR) || this.decoder.state.equals((Object)J106Decoder.DecoderState.FAILED_TAIL_ERROR) || this.decoder.state.equals((Object)J106Decoder.DecoderState.FAILED_TIME_OUT)) {
                System.out.println("WINDOW SHOWS: " + (Object)((Object)this.decoder.state));
                this.updateStatusMeter(0.75);
                this.decoder.isStarted = false;
                this.decoding = false;
                this.updateVuMeter(-200.0);
                this.recordButton.setEnabled(true);
                this.stopButton.setEnabled(false);
            }
        }
    }

    private static enum ComponentId implements JCustomEvent.SourceId
    {
        k_button_record,
        k_button_stop,
        k_button_play,
        k_button_save,
        k_button_reset;

    }

    class GuiUpdater
    implements Runnable {
        GuiUpdater() {
        }

        @Override
        public void run() {
            Core.debugPrint("ENTER MONITORING");
            while (TapeWindow.this.decoding) {
                double power = Math.max(TapeWindow.this.decoder.getAveragePower(), -96.0);
                TapeWindow.this.updateVuMeter(power);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Core.debugPrint("EXIT MONITORING");
        }
    }
}

