/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.library;

import java.text.Collator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;
import org.bjno.j106.gui.Core;
import org.bjno.j106.library.ExtendedPatch;

public class ExtendedLibrary {
    private String name;
    private Vector<ExtendedPatch> v;

    public int addPatchClever(ExtendedPatch p) {
        p.setName(this.getUniquePatchName(p.getName()));
        return this.addPatch(p);
    }

    public String getUniquePatchName(String aName) {
        int number;
        String base;
        if (this.getPatch(aName) == null) {
            return aName;
        }
        String n = aName;
        int left = n.lastIndexOf("(");
        int right = n.lastIndexOf(")");
        if (left == -1 || right == -1 || right != n.length() - 1) {
            base = n + " ";
            number = 1;
        } else {
            String possibleDigit = n.substring(left + 1, right);
            base = n.substring(0, left);
            try {
                number = Integer.valueOf(possibleDigit);
            }
            catch (NumberFormatException nfe) {
                base = n + " ";
                number = 1;
            }
        }
        String newName = base + "(" + number + ")";
        while (this.getPatch(newName) != null) {
            newName = base + "(" + ++number + ")";
        }
        return newName;
    }

    public int duplicatePatch(int index) {
        return this.addPatchClever(new ExtendedPatch(this.getPatch(index)));
    }

    public ExtendedLibrary() {
        this.name = "New Library";
        this.v = new Vector();
    }

    public ExtendedLibrary(String aName) {
        this.name = aName;
        this.v = new Vector();
    }

    public ExtendedLibrary(ExtendedLibrary aLibrary) {
        this.name = aLibrary.getName();
        this.v = new Vector();
        for (int i = 0; i < aLibrary.size(); ++i) {
            this.addPatch(new ExtendedPatch(aLibrary.getPatch(i)));
        }
    }

    public int size() {
        return this.v.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public int addPatch(ExtendedPatch p) {
        int i;
        if (this.indexOf(p) != -1) {
            this.v.set(this.indexOf(p), p);
            return this.indexOf(p);
        }
        Collator c = Collator.getInstance();
        c.setStrength(0);
        for (i = 0; i < this.size() && c.compare(this.getPatch(i).getName(), p.getName()) <= 0; ++i) {
        }
        this.v.add(i, p);
        return i;
    }

    public ExtendedPatch getPatch(int i) {
        if (i < this.size()) {
            return this.v.elementAt(i);
        }
        return null;
    }

    public ExtendedPatch getPatch(String name) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getPatch(i).getName().equals(name)) continue;
            return this.getPatch(i);
        }
        return null;
    }

    public int indexOf(ExtendedPatch p) {
        for (int i = 0; i < this.size(); ++i) {
            if (p.compareTo(this.getPatch(i)) != 0) continue;
            return i;
        }
        return -1;
    }

    public void remove(int i) {
        this.v.remove(i);
    }

    public static ExtendedLibrary getInitLibrary() {
        ExtendedLibrary tmp = new ExtendedLibrary("New Library");
        tmp.addPatch(new ExtendedPatch());
        return tmp;
    }

    public boolean isInitLibrary() {
        ExtendedLibrary tmp = ExtendedLibrary.getInitLibrary();
        return ExtendedLibrary.equals(this, tmp);
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Library: ");
        sbuff.append(this.name);
        sbuff.append("\n");
        for (int i = 0; i < this.size(); ++i) {
            sbuff.append(this.getPatch(i).toString() + " " + Arrays.toString(this.getPatch(i).getSysex()));
            if (i >= this.size() - 1) continue;
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    public static boolean equals(ExtendedLibrary l1, ExtendedLibrary l2) {
        if (l1.size() != l2.size() || !l1.name.equals(l2.name)) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (!l1.getPatch(i).getName().equals(l2.getPatch(i).getName())) {
                return false;
            }
            if (Arrays.toString(l1.getPatch(i).getSysex()).equals(Arrays.toString(l2.getPatch(i).getSysex()))) continue;
            return false;
        }
        return true;
    }

    public static int[] qualitativeCompare(ExtendedLibrary l1, ExtendedLibrary l2) {
        int[] result = new int[]{0, 0, 0};
        for (int i = 0; i < l1.size(); ++i) {
            for (int j = 0; j < l2.size(); ++j) {
                if (l1.getPatch(i).getName().equals(l2.getPatch(j).getName())) {
                    Core.debugPrint(l1.getPatch(i).getName());
                    if (Arrays.toString(l1.getPatch(i).getSysex()).equals(Arrays.toString(l2.getPatch(j).getSysex()))) {
                        result[0] = result[0] + 1;
                        result[2] = result[2] + 1;
                        Core.debugPrint("---ND " + l2.getPatch(j).getName());
                    } else {
                        Core.debugPrint("---N- " + l2.getPatch(j).getName());
                    }
                    result[1] = result[1] + 1;
                    continue;
                }
                if (!Arrays.toString(l1.getPatch(i).getSysex()).equals(Arrays.toString(l2.getPatch(j).getSysex()))) continue;
                result[2] = result[2] + 1;
                Core.debugPrint(l1.getPatch(i).getName());
                Core.debugPrint("----D " + l2.getPatch(j).getName());
            }
        }
        return result;
    }

    public static ExtendedLibrary trimForDuplicates(ExtendedLibrary l, int numDigits) {
        ExtendedLibrary result = new ExtendedLibrary(l.name);
        BitSet isCopy = new BitSet(l.size());
        int numberOfUnique = 0;
        String formatString = numDigits == 0 ? "%d" : "%0" + numDigits + "d";
        for (int i = 0; i < l.size(); ++i) {
            if (isCopy.get(i)) continue;
            ExtendedPatch unique = new ExtendedPatch(l.getPatch(i));
            unique.setName(String.format(formatString, numberOfUnique) + " " + unique.getName());
            for (int j = i + 1; j < l.size(); ++j) {
                if (!Arrays.toString(unique.getSysex()).equals(Arrays.toString(l.getPatch(j).getSysex()))) continue;
                ExtendedPatch copy = new ExtendedPatch(l.getPatch(j));
                copy.setName(String.format(formatString, numberOfUnique) + " " + copy.getName());
                isCopy.set(j);
                result.addPatch(copy);
            }
            ++numberOfUnique;
            result.addPatch(unique);
        }
        return result;
    }

    public static int getNrofUnique(ExtendedLibrary l) {
        BitSet isCopy = new BitSet(l.size());
        int numberOfUnique = 0;
        for (int i = 0; i < l.size(); ++i) {
            if (isCopy.get(i)) continue;
            for (int j = i + 1; j < l.size(); ++j) {
                if (!Arrays.toString(l.getPatch(i).getSysex()).equals(Arrays.toString(l.getPatch(j).getSysex()))) continue;
                isCopy.set(j);
            }
            ++numberOfUnique;
        }
        return numberOfUnique;
    }
}

