/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.library;

import java.util.Arrays;
import java.util.Random;
import java.util.UUID;

public class ExtendedPatch
implements Comparable<ExtendedPatch> {
    private byte[] sysex = null;
    private String name = null;
    private String uid = null;
    private long creationTime;

    private void setTimeAndId() {
        this.uid = UUID.randomUUID().toString();
        this.creationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getUid() {
        return this.uid;
    }

    public ExtendedPatch() {
        this.setTimeAndId();
        this.sysex = new byte[18];
        this.name = new String();
        this.init();
        this.setName("Init");
    }

    public ExtendedPatch(ExtendedPatch p) {
        this.setTimeAndId();
        this.sysex = (byte[])p.sysex.clone();
        this.name = new String(p.getName());
    }

    public ExtendedPatch(String aName) {
        this.setTimeAndId();
        this.sysex = new byte[18];
        this.name = new String(aName);
        this.init();
    }

    public ExtendedPatch(String aName, byte[] aSysex) {
        this.setTimeAndId();
        this.sysex = aSysex;
        this.name = aName;
    }

    public ExtendedPatch(String aName, byte[] aSysex, String aUid, long aCreationTime) {
        if (this.uid != null) {
            this.uid = aUid;
        } else {
            this.setTimeAndId();
        }
        this.creationTime = aCreationTime;
        this.sysex = aSysex;
        this.name = aName;
    }

    public boolean deepEquals(ExtendedPatch another) {
        return this.getName().equals(another.getName()) && Arrays.equals(this.getSysex(), another.getSysex());
    }

    public static int[] qualitativeCompare(ExtendedPatch p1, ExtendedPatch p2) {
        int[] result = new int[]{0, 0};
        result[0] = result[0] + (p1.getLFOrate() == p2.getLFOrate() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getLFOrate() - p2.getLFOrate()));
        result[0] = result[0] + (p1.getLFOdelay() == p2.getLFOdelay() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getLFOdelay() - p2.getLFOdelay()));
        result[0] = result[0] + (p1.getDCOLFO() == p2.getDCOLFO() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getDCOLFO() - p2.getDCOLFO()));
        result[0] = result[0] + (p1.getnoiselevel() == p2.getnoiselevel() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getnoiselevel() - p2.getnoiselevel()));
        result[0] = result[0] + (p1.getVCFcutoff() == p2.getVCFcutoff() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getVCFcutoff() - p2.getVCFcutoff()));
        result[0] = result[0] + (p1.getresonance() == p2.getresonance() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getresonance() - p2.getresonance()));
        result[0] = result[0] + (p1.getVCFENV() == p2.getVCFENV() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getVCFENV() - p2.getVCFENV()));
        result[0] = result[0] + (p1.getVCFLFO() == p2.getVCFLFO() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getVCFLFO() - p2.getVCFLFO()));
        result[0] = result[0] + (p1.getVCFKYBD() == p2.getVCFKYBD() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getVCFKYBD() - p2.getVCFKYBD()));
        result[0] = result[0] + (p1.getVCAlevel() == p2.getVCAlevel() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getVCAlevel() - p2.getVCAlevel()));
        result[0] = result[0] + (p1.getattack() == p2.getattack() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getattack() - p2.getattack()));
        result[0] = result[0] + (p1.getdecay() == p2.getdecay() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getdecay() - p2.getdecay()));
        result[0] = result[0] + (p1.getsustain() == p2.getsustain() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getsustain() - p2.getsustain()));
        result[0] = result[0] + (p1.getrelease() == p2.getrelease() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getrelease() - p2.getrelease()));
        result[0] = result[0] + (p1.getsublevel() == p2.getsublevel() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getsublevel() - p2.getsublevel()));
        result[0] = result[0] + (p1.getrange() == p2.getrange() ? 0 : 1);
        result[1] = Math.max(result[1], Math.abs(p1.getsublevel() - p2.getsublevel()));
        result[0] = result[0] + (p1.getpulse() == p2.getpulse() ? 0 : 1);
        result[0] = result[0] + (p1.getsaw() == p2.getsaw() ? 0 : 1);
        result[0] = result[0] + (p1.getchorus() == p2.getchorus() ? 0 : 1);
        result[0] = result[0] + (p1.getHPfilter() == p2.getHPfilter() ? 0 : 1);
        result[0] = result[0] + (p1.getPWM().equals(p2.getPWM()) ? 0 : 1);
        result[0] = result[0] + (p1.getENV().equals(p2.getENV()) ? 0 : 1);
        result[0] = result[0] + (p1.getVCA().equals(p2.getVCA()) ? 0 : 1);
        return result;
    }

    private int rand(int value, int mult) {
        Random r = new Random();
        r.nextDouble();
        int tmp = mult - r.nextInt(2 * mult + 1);
        value += tmp;
        value = Math.min(value, 127);
        value = Math.max(value, 0);
        return value;
    }

    public void randomize() {
        int mult = 15;
        this.setLFOrate(this.rand(this.getLFOrate(), mult));
        this.setLFOdelay(this.rand(this.getLFOdelay(), mult));
        this.setDCOLFO(this.rand(this.getDCOLFO(), mult));
        this.setDCOPWM(this.rand(this.getDCOPWM(), mult));
        this.setnoiselevel(this.rand(this.getnoiselevel(), mult));
        this.setVCFcutoff(this.rand(this.getVCFcutoff(), mult));
        this.setresonance(this.rand(this.getresonance(), mult));
        this.setVCFENV(this.rand(this.getVCFENV(), mult));
        this.setVCFLFO(this.rand(this.getVCFLFO(), mult));
        this.setVCFKYBD(this.rand(this.getVCFKYBD(), mult));
        this.setVCAlevel(this.rand(this.getVCAlevel(), mult));
        this.setattack(this.rand(this.getattack(), mult));
        this.setdecay(this.rand(this.getdecay(), mult));
        this.setsustain(this.rand(this.getsustain(), mult));
        this.setrelease(this.rand(this.getrelease(), mult));
        this.setsublevel(this.rand(this.getsublevel(), mult));
        double p = 0.1;
        Random r = new Random();
        if (r.nextDouble() < p) {
            if (this.getrange() == 16 || this.getrange() == 4) {
                this.setrange(8);
            } else if (r.nextBoolean()) {
                this.setrange(16);
            } else {
                this.setrange(4);
            }
        }
        if (r.nextDouble() < p) {
            this.setpulse(!this.getpulse());
        }
        if (r.nextDouble() < p) {
            this.setsaw(!this.getsaw());
        }
        if (r.nextDouble() < p) {
            this.setchorus(r.nextInt(3));
        }
        if (r.nextDouble() < p) {
            if (this.getPWM().equals("LFO")) {
                this.setPWM("MAN");
            } else {
                this.setPWM("LFO");
            }
        }
        if (r.nextDouble() < p) {
            if (this.getENV().equals("+")) {
                this.setENV("-");
            } else {
                this.setENV("+");
            }
        }
        if (r.nextDouble() < p) {
            if (this.getVCA().equals("gate")) {
                this.setVCA("ENV");
            } else {
                this.setVCA("gate");
            }
        }
        if (r.nextDouble() < p) {
            this.setHPfilter(r.nextInt(4));
        }
    }

    public void init() {
        this.setLFOrate(0);
        this.setLFOdelay(0);
        this.setDCOLFO(0);
        this.setDCOPWM(0);
        this.setnoiselevel(0);
        this.setVCFcutoff(127);
        this.setresonance(0);
        this.setVCFENV(0);
        this.setVCFLFO(0);
        this.setVCFKYBD(0);
        this.setVCAlevel(127);
        this.setattack(0);
        this.setdecay(0);
        this.setsustain(0);
        this.setrelease(0);
        this.setsublevel(0);
        this.setrange(8);
        this.setpulse(true);
        this.setsaw(false);
        this.setchorus(0);
        this.setPWM("MAN");
        this.setENV("+");
        this.setVCA("gate");
        this.setHPfilter(0);
    }

    public void set(byte b, int pos) {
        this.sysex[pos] = b;
    }

    public void set(int i, int pos) {
        this.sysex[pos] = (byte)i;
    }

    private byte get(int pos) {
        return this.sysex[pos];
    }

    public byte[] getSysex() {
        return this.sysex;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName() + " " + Arrays.toString(this.sysex);
    }

    @Override
    public int compareTo(ExtendedPatch o) {
        String s1 = this.getName();
        String s2 = o.getName();
        return s1.compareTo(s2);
    }

    public int getLFOrate() {
        return this.sysex[0];
    }

    public void setLFOrate(int i) {
        this.sysex[0] = (byte)i;
    }

    public int getLFOdelay() {
        return this.sysex[1];
    }

    public void setLFOdelay(int i) {
        this.sysex[1] = (byte)i;
    }

    public int getDCOLFO() {
        return this.sysex[2];
    }

    public void setDCOLFO(int i) {
        this.sysex[2] = (byte)i;
    }

    public int getDCOPWM() {
        return this.sysex[3];
    }

    public void setDCOPWM(int i) {
        this.sysex[3] = (byte)i;
    }

    public int getnoiselevel() {
        return this.sysex[4];
    }

    public void setnoiselevel(int i) {
        this.sysex[4] = (byte)i;
    }

    public int getVCFcutoff() {
        return this.sysex[5];
    }

    public void setVCFcutoff(int i) {
        this.sysex[5] = (byte)i;
    }

    public int getresonance() {
        return this.sysex[6];
    }

    public void setresonance(int i) {
        this.sysex[6] = (byte)i;
    }

    public int getVCFENV() {
        return this.sysex[7];
    }

    public void setVCFENV(int i) {
        this.sysex[7] = (byte)i;
    }

    public int getVCFLFO() {
        return this.sysex[8];
    }

    public void setVCFLFO(int i) {
        this.sysex[8] = (byte)i;
    }

    public int getVCFKYBD() {
        return this.sysex[9];
    }

    public void setVCFKYBD(int i) {
        this.sysex[9] = (byte)i;
    }

    public int getVCAlevel() {
        return this.sysex[10];
    }

    public void setVCAlevel(int i) {
        this.sysex[10] = (byte)i;
    }

    public int getattack() {
        return this.sysex[11];
    }

    public void setattack(int i) {
        this.sysex[11] = (byte)i;
    }

    public int getdecay() {
        return this.sysex[12];
    }

    public void setdecay(int i) {
        this.sysex[12] = (byte)i;
    }

    public int getsustain() {
        return this.sysex[13];
    }

    public void setsustain(int i) {
        this.sysex[13] = (byte)i;
    }

    public int getrelease() {
        return this.sysex[14];
    }

    public void setrelease(int i) {
        this.sysex[14] = (byte)i;
    }

    public int getsublevel() {
        return this.sysex[15];
    }

    public void setsublevel(int i) {
        this.sysex[15] = (byte)i;
    }

    public int getrange() {
        return 16 / (this.get(16) & 7);
    }

    public void setrange(int i) {
        this.set(this.get(16) & 0x78 | 16 / i, 16);
    }

    public boolean getpulse() {
        return (this.get(16) & 8) > 0;
    }

    public void setpulse(boolean b) {
        if (b) {
            this.set(this.get(16) & 0x77 | 8, 16);
        } else {
            this.set(this.get(16) & 0x77, 16);
        }
    }

    public boolean getsaw() {
        return (this.get(16) & 0x10) > 0;
    }

    public void setsaw(boolean b) {
        if (b) {
            this.set(this.get(16) & 0x6F | 0x10, 16);
        } else {
            this.set(this.get(16) & 0x6F, 16);
        }
    }

    public int getchorus() {
        if ((this.get(16) & 0x20) > 0) {
            return 0;
        }
        if ((this.get(16) & 0x40) > 0) {
            return 1;
        }
        return 2;
    }

    public void setchorus(int i) {
        if (i == 0) {
            this.set(this.get(16) & 0x1F | 0x20, 16);
        }
        if (i == 1) {
            this.set(this.get(16) & 0x1F | 0x40, 16);
        }
        if (i == 2) {
            this.set(this.get(16) & 0x1F, 16);
        }
    }

    public String getPWM() {
        if ((this.get(17) & 1) == 1) {
            return "MAN";
        }
        return "LFO";
    }

    public void setPWM(String s) {
        if (s == "MAN") {
            this.set(this.get(17) | 1, 17);
        }
        if (s == "LFO") {
            this.set(this.get(17) & 0x7E, 17);
        }
    }

    public String getENV() {
        if ((this.get(17) & 2) > 0) {
            return "-";
        }
        return "+";
    }

    public void setENV(String s) {
        if (s == "-") {
            this.set(this.get(17) | 2, 17);
        }
        if (s == "+") {
            this.set(this.get(17) & 0x7D, 17);
        }
    }

    public String getVCA() {
        if ((this.get(17) & 4) > 0) {
            return "gate";
        }
        return "ENV";
    }

    public void setVCA(String s) {
        if (s == "gate") {
            this.set(this.get(17) | 4, 17);
        }
        if (s == "ENV") {
            this.set(this.get(17) & 0x7B, 17);
        }
    }

    public void setHPfilter(int i) {
        if (i == 0) {
            this.set(this.get(17) & 7 | 0x18, 17);
        }
        if (i == 1) {
            this.set(this.get(17) & 7 | 0x10, 17);
        }
        if (i == 2) {
            this.set(this.get(17) & 7 | 8, 17);
        }
        if (i == 3) {
            this.set(this.get(17) & 7, 17);
        }
    }

    public int getHPfilter() {
        if ((this.get(17) & 0x18) == 24) {
            return 0;
        }
        if ((this.get(17) & 0x18) == 16) {
            return 1;
        }
        if ((this.get(17) & 0x18) == 8) {
            return 2;
        }
        if ((this.get(17) & 0x18) == 0) {
            return 3;
        }
        return -1;
    }
}

