/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.midi;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.SysexMessage;
import org.bjno.j106.library.ExtendedPatch;

public class MidiTranslator {
    private static final int[] ju06Adress = new int[]{1536, 1538, 1794, 1796, 1806, 2050, 2052, 2056, 2058, 2060, 2306, 2560, 2562, 2564, 2566, 1804};

    private static byte[] getJu06Sysex(int ju06control, int aValue) {
        byte[] syx = new byte[]{-16, 65, 16, 0, 0, 0, 29, 18, 3, 0, 0, 0, 0, 0, 0, -9};
        syx[10] = (byte)(ju06control >> 8);
        syx[11] = (byte)(ju06control & 0xFF);
        syx[12] = (byte)((aValue & 0xF0) >> 4);
        syx[13] = (byte)(aValue & 0xF);
        int checksum = 0;
        for (int i = 1; i < 14; ++i) {
            checksum += syx[i] & 0xFF;
        }
        checksum = 256 - checksum & 0x7F;
        syx[14] = (byte)checksum;
        return syx;
    }

    public SysexMessage controlToMidiMessage(int aControl, int aValue) {
        SysexMessage s = null;
        try {
            s = new SysexMessage(MidiTranslator.getJu06Sysex(aControl, aValue), 16);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        return s;
    }

    public ArrayList<SysexMessage> patchToMidiMessages(ExtendedPatch p) {
        ArrayList<SysexMessage> messages = new ArrayList<SysexMessage>();
        byte[] sysex = p.getSysex();
        try {
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(1798, 1 - (sysex[17] & 1)), 16));
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(2054, 1 - ((sysex[17] & 2) >> 1)), 16));
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(2304, 1 - ((sysex[17] & 4) >> 2)), 16));
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(2048, 85 * (3 - ((sysex[17] & 0x18) >> 3))), 16));
            for (int id = 0; id < 16; ++id) {
                messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(ju06Adress[id], (int)Math.floor((double)sysex[id] * 2.00787402)), 16));
            }
            int tmp = 0;
            if ((sysex[16] & 7) == 4) {
                tmp = 2;
            } else if ((sysex[16] & 7) == 2) {
                tmp = 1;
            }
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(1792, tmp), 16));
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(1800, (sysex[16] & 8) >> 3), 16));
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(1802, (sysex[16] & 0x10) >> 4), 16));
            int chorusVal = 0;
            chorusVal = (sysex[16] & 0x20) > 0 ? 0 : ((sysex[16] & 0x40) > 0 ? 1 : 2);
            messages.add(new SysexMessage(MidiTranslator.getJu06Sysex(4096, chorusVal), 16));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        return messages;
    }
}

