/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.waves;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;

public class J106Decoder
implements Runnable {
    private TargetDataLine line;
    private AudioFormat format;
    private byte[] audioBuffer;
    private short[] sampleBuffer;
    public boolean isStarted = true;
    private final int decodingPeriodMs = 100;
    private final int samplingRate = 44100;
    private final int bytesPerFrame = 2;
    private final int bufferMargin = 5;
    DecoderStateListener listener;
    private static final int HALF_PERIOD_VALID_LOWER = 1;
    private static final int HALF_PERIOD_VALID_UPPER = 100;
    private static final int HALF_PERIOD_ZERO_TO_ONE_THRES = 20;
    private static final int MAX_NUMBER_OF_BITS = 20000;
    private static final int FILTER_SMOOTH_LENGTH = 8;
    private static final int NUMBER_OF_SYNC_ONES = 500;
    private static final int NUMBER_OF_HEADER_BITS = 20;
    private static final int NUMBER_OF_EXPECTED_BITS = 10290;
    private static final double POWER_FORGETTING_FACTOR_DOWN = 5.0E-4;
    private static final double POWER_FORGETTING_FACTOR_UP = 1.0;
    private long sampleCounter;
    private int bitCounter;
    private int smootherPointer;
    private long filterSum;
    private long lastZeroCrossing;
    private long lastValue;
    private long numberOfOnes;
    private long[] smoother;
    private byte[] decodedBits;
    private double averagePower;
    public DecoderState state = DecoderState.SYNC_TONE_NOT_FOUND;

    public J106Decoder(DecoderStateListener aListener, boolean recorder) {
        this.listener = aListener;
        if (recorder) {
            this.init();
        }
    }

    private void init() {
        int bufferSize = 44100;
        this.line = null;
        this.format = new AudioFormat(44100.0f, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.format);
        if (!AudioSystem.isLineSupported(info)) {
            // empty if block
        }
        try {
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.open(this.format, bufferSize);
        }
        catch (LineUnavailableException lineUnavailableException) {
            // empty catch block
        }
        this.audioBuffer = new byte[this.line.getBufferSize() / 5];
        this.sampleBuffer = new short[this.audioBuffer.length / 2];
    }

    public void initDecoderStates() {
        this.smoother = new long[8];
        this.decodedBits = new byte[20000];
        this.sampleCounter = 0L;
        this.bitCounter = 0;
        this.smootherPointer = 0;
        this.filterSum = 0L;
        this.lastZeroCrossing = 0L;
        this.lastValue = 0L;
        this.numberOfOnes = 0L;
        this.averagePower = 0.0;
        this.state = DecoderState.SYNC_TONE_NOT_FOUND;
    }

    @Override
    public void run() {
        this.line.start();
        while (this.isStarted) {
            int numberOfBytesRead = this.line.read(this.audioBuffer, 0, this.audioBuffer.length);
            try {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.audioBuffer));
                for (int i = 0; i < numberOfBytesRead / 2; ++i) {
                    this.sampleBuffer[i] = dis.readShort();
                }
                this.pushData(this.sampleBuffer, numberOfBytesRead / 2);
            }
            catch (IOException iOException) {}
        }
        this.line.stop();
    }

    private void setState(DecoderState newState) {
        this.state = newState;
        if (this.listener != null) {
            this.listener.notifyStateChange();
        }
    }

    private void updatePowerMeasurement(int sample) {
        double measurement = (double)Math.abs(sample) / 32767.0;
        double forgettingFactor = 5.0E-4;
        if (measurement > this.averagePower) {
            forgettingFactor = 1.0;
        }
        this.averagePower = forgettingFactor * measurement + (1.0 - forgettingFactor) * this.averagePower;
    }

    public double getAveragePower() {
        return 10.0 * Math.log10(this.averagePower);
    }

    public void pushData(short[] samples, long numberOfSamples) {
        if (this.state.equals((Object)DecoderState.SUCCESSFUL_DECODING) || this.state.equals((Object)DecoderState.FAILED_HEADER_ERROR) || this.state.equals((Object)DecoderState.FAILED_TAIL_ERROR) || this.state.equals((Object)DecoderState.FAILED_BYTE_FORMAT_ERROR) || this.state.equals((Object)DecoderState.FAILED_CHECKSUM_ERROR)) {
            return;
        }
        int i = 0;
        while ((long)i < numberOfSamples) {
            this.updatePowerMeasurement(samples[i]);
            this.filterSum -= this.smoother[this.smootherPointer];
            this.filterSum += (long)samples[i];
            this.smoother[this.smootherPointer] = samples[i];
            this.smootherPointer = (short)((this.smootherPointer + 1) % 8);
            int sign = 0;
            sign = this.filterSum >= 0L ? 1 : -1;
            if (this.sampleCounter - this.lastZeroCrossing > 500L) {
                this.decode((short)-1);
                this.lastZeroCrossing = this.sampleCounter;
                this.lastValue = sign;
            }
            if ((long)sign != this.lastValue) {
                long halfPeriod = this.sampleCounter - this.lastZeroCrossing;
                short bit = -1;
                bit = halfPeriod < 1L || halfPeriod > 100L ? (short)-1 : (halfPeriod < 20L ? (short)0 : 1);
                this.decode(bit);
                this.lastZeroCrossing = this.sampleCounter;
                this.lastValue = sign;
            }
            ++this.sampleCounter;
            ++i;
        }
    }

    private void decode(short newBit) {
        if (this.state.equals((Object)DecoderState.SYNC_TONE_NOT_FOUND)) {
            if (newBit == 1) {
                ++this.numberOfOnes;
            } else {
                if (newBit == 0) {
                    this.numberOfOnes = 0L;
                    return;
                }
                if (newBit == -1) {
                    this.numberOfOnes = 0L;
                    return;
                }
            }
            if (this.numberOfOnes == 500L) {
                this.setState(DecoderState.SYNC_TONE_FOUND);
            }
        }
        if (this.state.equals((Object)DecoderState.SYNC_TONE_FOUND)) {
            if (newBit == -1) {
                this.numberOfOnes = 0L;
                this.setState(DecoderState.SYNC_TONE_NOT_FOUND);
                return;
            }
            if (newBit == 1) {
                ++this.numberOfOnes;
            } else if (newBit == 0) {
                this.setState(DecoderState.ATTEMPT_DECODING);
                this.numberOfOnes = 0L;
            }
        }
        if (this.state.equals((Object)DecoderState.ATTEMPT_DECODING) || this.state.equals((Object)DecoderState.HEADER_MATCH)) {
            if (newBit == -1) {
                if (this.state.equals((Object)DecoderState.HEADER_MATCH)) {
                    this.setState(DecoderState.FAILED_TIME_OUT);
                } else {
                    this.setState(DecoderState.SYNC_TONE_NOT_FOUND);
                }
                this.bitCounter = 0;
                return;
            }
            this.decodedBits[this.bitCounter] = (byte)newBit;
            ++this.bitCounter;
            if (this.bitCounter == 20) {
                if (J106Decoder.bitArrayToByte(this.decodedBits, 0, 10) != 660 || J106Decoder.bitArrayToByte(this.decodedBits, 10, 10) != 682) {
                    this.bitCounter = 0;
                    this.setState(DecoderState.SYNC_TONE_NOT_FOUND);
                    return;
                }
                this.setState(DecoderState.HEADER_MATCH);
            }
            if (this.bitCounter < 20 || this.bitCounter < 10290) {
                // empty if block
            }
            if (this.bitCounter == 10290) {
                if (!J106Decoder.verifyByteFormat(this.decodedBits)) {
                    this.setState(DecoderState.FAILED_BYTE_FORMAT_ERROR);
                    return;
                }
                if (!J106Decoder.verifyTail(this.decodedBits)) {
                    this.setState(DecoderState.FAILED_TAIL_ERROR);
                    return;
                }
                if (!J106Decoder.verifyCheckSum(this.decodedBits)) {
                    this.setState(DecoderState.FAILED_CHECKSUM_ERROR);
                    return;
                }
                this.setState(DecoderState.SUCCESSFUL_DECODING);
            }
            if (this.state.equals((Object)DecoderState.SUCCESSFUL_DECODING) || this.state.equals((Object)DecoderState.FAILED_TIME_OUT) || this.state.equals((Object)DecoderState.FAILED_HEADER_ERROR) || this.state.equals((Object)DecoderState.FAILED_TAIL_ERROR) || this.state.equals((Object)DecoderState.FAILED_BYTE_FORMAT_ERROR) || this.state.equals((Object)DecoderState.FAILED_CHECKSUM_ERROR)) {
                // empty if block
            }
        }
    }

    public static short bitArrayToByte(byte[] bits, int offset, int nbits) {
        short result = 0;
        for (int i = 0; i < nbits; i = (int)((short)(i + 1))) {
            result = (short)(result + bits[i + offset] * (1 << i));
        }
        return result;
    }

    private static boolean verifyByteFormat(byte[] bits) {
        int i;
        int leftSum = 0;
        int rightSum = 0;
        for (i = 0; i < 1029; ++i) {
            leftSum += bits[i * 10];
        }
        for (i = 0; i < 1028; ++i) {
            rightSum += bits[i * 10 + 9];
        }
        return leftSum == 0 && rightSum == 1028;
    }

    private static boolean verifyCheckSum(byte[] bits) {
        long checksum = 0L;
        for (int i = 0; i < 1026; ++i) {
            checksum += (long)J106Decoder.bitArrayToByte(bits, i * 10 + 1, 8);
        }
        return (checksum %= 256L) == (long)J106Decoder.bitArrayToByte(bits, 10261, 8);
    }

    private static boolean verifyTail(byte[] bits) {
        return J106Decoder.bitArrayToByte(bits, 10271, 8) == 170 && J106Decoder.bitArrayToByte(bits, 10281, 8) == 170;
    }

    public ExtendedLibrary getReceivedLibrary(String aBankLocation, String aBankName, boolean aStartWithLocation) {
        ExtendedLibrary receivedLibrary = new ExtendedLibrary();
        receivedLibrary.setName(aBankName + " (tape import)");
        byte[] infoBits = Arrays.copyOfRange(this.decodedBits, 20, 11540);
        for (int i = 0; i < 64; ++i) {
            int j;
            byte[] sysexOutput = new byte[18];
            for (j = 0; j < 16; ++j) {
                sysexOutput[j] = (byte)J106Decoder.bitArrayToByte(infoBits, (i * 16 + j) * 10 + 1, 7);
            }
            sysexOutput[17] = 0;
            sysexOutput[16] = 0;
            for (j = 0; j < 7; ++j) {
                sysexOutput[16] = (byte)(sysexOutput[16] + (infoBits[(i * 16 + j) * 10 + 8] << j));
            }
            for (j = 0; j < 5; ++j) {
                sysexOutput[17] = (byte)(sysexOutput[17] + (infoBits[(i * 16 + j + 8) * 10 + 8] << j));
            }
            int asciiOffset = 48;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(aBankLocation);
            sbuf.append((char)(i / 8 + 1 + asciiOffset));
            sbuf.append((char)(i % 8 + 1 + asciiOffset));
            if (aStartWithLocation) {
                sbuf.append(" " + aBankName);
            } else {
                sbuf.insert(0, aBankName + " ");
            }
            ExtendedPatch receivedPatch = new ExtendedPatch(sbuf.toString(), sysexOutput);
            receivedLibrary.addPatch(receivedPatch);
        }
        return receivedLibrary;
    }

    public static enum DecoderState {
        SYNC_TONE_NOT_FOUND,
        SYNC_TONE_FOUND,
        ATTEMPT_DECODING,
        HEADER_MATCH,
        SUCCESSFUL_DECODING,
        FAILED_HEADER_ERROR,
        FAILED_TIME_OUT,
        FAILED_TAIL_ERROR,
        FAILED_BYTE_FORMAT_ERROR,
        FAILED_CHECKSUM_ERROR;

    }

    public static interface DecoderStateListener {
        public void notifyStateChange();
    }
}

