/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j106.waves;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.bjno.j106.library.ExtendedLibrary;
import org.bjno.j106.library.ExtendedPatch;
import org.bjno.j106.waves.J106Decoder;

public class J106Encoder
implements Runnable {
    EncoderState state = EncoderState.NOT_STARTED;
    private byte[] encodedBits;
    private static final int ENCODER_INFORMATION_BITS = 10290;
    private static final int NR_OF_HEADER_BITS = 20;
    private static final int ENCODER_SYNCTONE_BITS = 3600;
    private static final int NUM_PATCHES_PER_BANK = 64;
    private static final double EXPONENTIAL_FILTER_FF = 0.3;
    SourceDataLine line;
    private float samplingRate = 44100.0f;
    private final int encodingPeriodMs = 100;
    boolean isRunning = true;
    int bitCounter;
    int waveformPointer;
    short currentSign = 1;
    long sampleCounter;
    private short memory = 0;
    private static short[] wavetable0 = new short[]{48, 16701, 28670, 32654, 30426, 25015, 16873};
    private static short[] wavetable1 = new short[]{1092, 8173, 13230, 16606, 18611, 19516, 19563, 18964, 17900, 16526, 14972, 13346, 11732, 10194, 8780, 7521, 6431, 5515, 4765, 4162, 3684, 3298, 2971, 2665, 2345, 1973, 1517, 950};
    private static final int NUM_SYMBOLS_TO_FADE = 10;
    private byte[] header = new byte[]{0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};
    private byte[] tail = new byte[]{0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0};

    public J106Encoder(boolean player) {
        if (player) {
            this.init();
        }
    }

    private void init() {
        this.line = null;
        AudioFormat format = new AudioFormat(this.samplingRate, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            // empty if block
        }
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(format);
        }
        catch (LineUnavailableException lineUnavailableException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.line.start();
        this.line.start();
        int numberOfFrames = (int)(0.1 * (double)this.samplingRate);
        short[] audioBuffer = new short[numberOfFrames];
        while (!this.state.equals((Object)EncoderState.SUCCESSFUL_ENCODING)) {
            ByteBuffer b = ByteBuffer.allocate(numberOfFrames * 2);
            this.encode(audioBuffer, numberOfFrames);
            for (int i = 0; i < numberOfFrames; ++i) {
                b.putShort(audioBuffer[i]);
            }
            this.line.write(b.array(), 0, numberOfFrames * 2);
        }
    }

    public EncodingStream getStream() {
        return new EncodingStream();
    }

    void setState(EncoderState newState) {
        this.state = newState;
    }

    static void byteToBitArray(byte b, byte[] bits, int offset, int nbits) {
        for (int i = 0; i < nbits; ++i) {
            bits[i + offset] = (byte)(b >> i & 1);
        }
    }

    public void setLibrary(ExtendedLibrary library, boolean prioritizeTop) {
        int i;
        long checksum = 0L;
        this.encodedBits = new byte[10290];
        for (int i2 = 0; i2 < 20; ++i2) {
            this.encodedBits[i2] = this.header[i2];
        }
        ExtendedPatch spare = null;
        int libraryOffset = 0;
        if (library.size() > 64 && !prioritizeTop) {
            libraryOffset = library.size() - 64;
        } else if (library.size() < 64) {
            spare = new ExtendedPatch();
        }
        for (i = 0; i < 64; ++i) {
            int j;
            byte[] sysex;
            for (int j2 = 0; j2 < 16; ++j2) {
                this.encodedBits[(i * 16 + j2) * 10 + 9 + 20] = 1;
                this.encodedBits[(i * 16 + j2) * 10 + 0 + 20] = 0;
            }
            if (library != null) {
                if (i + libraryOffset < library.size()) {
                    sysex = library.getPatch(i + libraryOffset).getSysex();
                } else {
                    sysex = spare.getSysex();
                    if (libraryOffset > 0) {
                        throw new RuntimeException("Faulty input");
                    }
                }
            } else {
                sysex = spare.getSysex();
            }
            for (j = 0; j < 16; ++j) {
                J106Encoder.byteToBitArray(sysex[j], this.encodedBits, (i * 16 + j) * 10 + 1 + 20, 7);
            }
            for (j = 0; j < 7; ++j) {
                this.encodedBits[(i * 16 + j) * 10 + 8 + 20] = (byte)(sysex[16] >> j & 1);
            }
            for (j = 0; j < 5; ++j) {
                this.encodedBits[(i * 16 + j + 8) * 10 + 8 + 20] = (byte)(sysex[17] >> j & 1);
            }
            if (this.encodedBits[(i * 16 + 5) * 10 + 8 + 20] + this.encodedBits[(i * 16 + 6) * 10 + 8 + 20] == 0) {
                this.encodedBits[(i * 16 + 7) * 10 + 8 + 20] = 1;
            }
            this.encodedBits[(i * 16 + 15) * 10 + 8 + 20] = 0;
            this.encodedBits[(i * 16 + 14) * 10 + 8 + 20] = 0;
            this.encodedBits[(i * 16 + 13) * 10 + 8 + 20] = 0;
        }
        for (i = 0; i < 1026; ++i) {
            checksum += (long)J106Decoder.bitArrayToByte(this.encodedBits, 1 + i * 10, 8);
        }
        this.encodedBits[10260] = 0;
        J106Encoder.byteToBitArray((byte)(checksum % 256L), this.encodedBits, 10261, 8);
        this.encodedBits[10269] = 1;
        for (i = 0; i < 20; ++i) {
            this.encodedBits[i + 10270] = this.tail[i];
        }
    }

    int encode(short[] audioBuffer, int numberOfSamples) {
        int audioBufferPointer = 0;
        while (!this.state.equals((Object)EncoderState.SUCCESSFUL_ENCODING)) {
            if (this.bitCounter == 0 && this.state.equals((Object)EncoderState.NOT_STARTED)) {
                this.setState(EncoderState.SYNC_TONE);
            }
            if (this.bitCounter == 3600 && this.state.equals((Object)EncoderState.SYNC_TONE)) {
                this.setState(EncoderState.ENCODING_DATA);
            }
            if (this.bitCounter == 13890 && this.state.equals((Object)EncoderState.ENCODING_DATA)) {
                this.setState(EncoderState.ENCODING_TAIL);
            }
            short currentBit = 0;
            if (this.state.equals((Object)EncoderState.SYNC_TONE) || this.state.equals((Object)EncoderState.ENCODING_TAIL)) {
                currentBit = 1;
            } else if (this.state.equals((Object)EncoderState.ENCODING_DATA)) {
                currentBit = this.encodedBits[this.bitCounter - 3600];
            }
            short[] currentWaveform = wavetable1;
            if (currentBit == 0) {
                currentWaveform = wavetable0;
            }
            while (this.waveformPointer < currentWaveform.length && audioBufferPointer < numberOfSamples) {
                short current = (short)(this.currentSign * currentWaveform[this.waveformPointer]);
                if (this.bitCounter < 10) {
                    double scale = (double)(this.bitCounter * currentWaveform.length + this.waveformPointer) / (double)(10 * currentWaveform.length);
                    current = (short)(scale * (double)current);
                } else if (this.bitCounter > 17479) {
                    int numBitsLeft = 17490 - this.bitCounter - 1;
                    double scale = (double)(numBitsLeft * currentWaveform.length + currentWaveform.length - this.waveformPointer) / (double)(10 * currentWaveform.length);
                    current = (short)(scale * (double)current);
                }
                audioBuffer[audioBufferPointer] = (short)(0.3 * (double)current + 0.7 * (double)this.memory);
                this.memory = audioBuffer[audioBufferPointer];
                ++this.waveformPointer;
                ++audioBufferPointer;
                ++this.sampleCounter;
            }
            if (audioBufferPointer == numberOfSamples) {
                if (this.waveformPointer == currentWaveform.length) {
                    ++this.bitCounter;
                    this.currentSign = (short)(this.currentSign * -1);
                    this.waveformPointer = 0;
                }
                return audioBufferPointer;
            }
            ++this.bitCounter;
            this.currentSign = (short)(this.currentSign * -1);
            this.waveformPointer = 0;
            if (this.bitCounter != 17490 || !this.state.equals((Object)EncoderState.ENCODING_TAIL)) continue;
            this.setState(EncoderState.SUCCESSFUL_ENCODING);
        }
        return audioBufferPointer;
    }

    public static enum EncoderState {
        NOT_STARTED,
        SYNC_TONE,
        ENCODING_DATA,
        ENCODING_TAIL,
        SUCCESSFUL_ENCODING;

    }

    public class EncodingStream
    extends AudioInputStream {
        public EncodingStream() {
            super(new ByteArrayInputStream(new byte[0]), new AudioFormat(44100.0f, 16, 1, true, true), -1L);
        }

        @Override
        public int available() {
            int nAvailable = 0;
            nAvailable = !J106Encoder.this.state.equals((Object)EncoderState.SUCCESSFUL_ENCODING) ? Integer.MAX_VALUE : 0;
            return nAvailable;
        }

        @Override
        public int read(byte[] byteArray, int nOffset, int nLength) {
            if (!J106Encoder.this.state.equals((Object)EncoderState.SUCCESSFUL_ENCODING)) {
                short[] audioBuffer = new short[nLength / 2];
                int numFrames = J106Encoder.this.encode(audioBuffer, nLength / 2);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
                for (int i = 0; i < nLength / 2; ++i) {
                    byteBuffer.putShort(audioBuffer[i]);
                }
                return numFrames * 2;
            }
            return -1;
        }
    }
}

