/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j7midi;

import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import org.bjno.j7midi.MidiUser;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;

public class MidiIn
implements Receiver {
    MidiDevice inputDevice = null;
    private Vector<MidiDevice.Info> listOfInputDevices;
    MidiUser user;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiIn(MidiUser u) {
        this.user = u;
        this.listOfInputDevices = new Vector();
        MidiDevice tmpDevice = null;
        try {
            MidiDevice.Info[] allDevices = CoreMidiDeviceProvider.getMidiDeviceInfo();
            for (int k = 0; k < allDevices.length; ++k) {
                tmpDevice = MidiSystem.getMidiDevice(allDevices[k]);
                if (tmpDevice.getMaxTransmitters() == 0) continue;
                this.listOfInputDevices.add(allDevices[k]);
            }
        }
        catch (MidiUnavailableException e) {
            System.out.println(e.toString());
        }
        finally {
            if (tmpDevice != null && tmpDevice.isOpen()) {
                tmpDevice.close();
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void send(MidiMessage m, long time) {
        this.user.receiveMidiMessage(m);
    }

    public void setPort(String name) throws MidiUnavailableException {
        String[] names = this.getAvailiblePorts();
        int choice = -1;
        for (int k = 0; k < names.length; ++k) {
            if (!names[k].equals(name)) continue;
            choice = k;
        }
        this.setPort(choice);
    }

    public void setPort(int choice) throws MidiUnavailableException {
        if (choice == -1) {
            this.reset();
        } else {
            if (this.inputDevice != null) {
                this.inputDevice.close();
            }
            this.inputDevice = MidiSystem.getMidiDevice(this.listOfInputDevices.get(choice));
            this.inputDevice.open();
            this.inputDevice.getTransmitter().setReceiver(this);
        }
    }

    public void reset() {
        if (this.inputDevice != null) {
            this.inputDevice.close();
        }
        this.inputDevice = null;
    }

    public String[] getAvailiblePorts() {
        String[] names = new String[this.listOfInputDevices.size()];
        for (int k = 0; k < this.listOfInputDevices.size(); ++k) {
            names[k] = this.listOfInputDevices.get(k).getName();
        }
        return names;
    }
}

