/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.j7midi;

import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;

public class MidiOut {
    MidiDevice outputDevice = null;
    String activePort = null;
    private Vector<MidiDevice.Info> listOfOutputDevices;

    public MidiOut() {
        this.initListOfDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initListOfDevices() {
        this.listOfOutputDevices = new Vector();
        MidiDevice tmpDevice = null;
        try {
            MidiDevice.Info[] allDevices = CoreMidiDeviceProvider.getMidiDeviceInfo();
            for (int k = 0; k < allDevices.length; ++k) {
                tmpDevice = MidiSystem.getMidiDevice(allDevices[k]);
                if (tmpDevice.getMaxReceivers() == 0) continue;
                this.listOfOutputDevices.add(allDevices[k]);
            }
        }
        catch (MidiUnavailableException e) {
            System.out.println(e.toString());
        }
        finally {
            if (tmpDevice != null && tmpDevice.isOpen()) {
                tmpDevice.close();
            }
        }
    }

    public void setPort(String name) throws MidiUnavailableException {
        String[] names = this.getAvailiblePorts();
        int choice = -1;
        for (int k = 0; k < names.length; ++k) {
            if (!names[k].equals(name)) continue;
            choice = k;
        }
        this.setPort(choice);
    }

    public void setPort(int choice) throws MidiUnavailableException {
        if (choice == -1) {
            this.reset();
            this.activePort = null;
        } else {
            this.activePort = this.getAvailiblePorts()[choice];
            if (this.outputDevice != null) {
                this.outputDevice.close();
            }
            this.outputDevice = MidiSystem.getMidiDevice(this.listOfOutputDevices.get(choice));
            this.outputDevice.open();
        }
    }

    public String getPortName() {
        return this.activePort;
    }

    public void send(MidiMessage m) {
        if (this.outputDevice != null) {
            try {
                this.outputDevice.getReceiver().send(m, -1L);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    public void reset() {
        if (this.outputDevice != null) {
            this.outputDevice.close();
        }
        this.outputDevice = null;
        this.activePort = null;
    }

    public String[] getAvailiblePorts() {
        String[] names = new String[this.listOfOutputDevices.size()];
        for (int k = 0; k < this.listOfOutputDevices.size(); ++k) {
            names[k] = this.listOfOutputDevices.get(k).getName();
        }
        return names;
    }
}

