/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.jcustomgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.bjno.jcustomgui.JCustomEvent;
import org.bjno.jcustomgui.JCustomGuiComponent;
import org.bjno.jcustomgui.JCustomListener;

public class JCustomButton
extends JPanel
implements JCustomGuiComponent {
    private final JCustomEvent.SourceId id;
    private final Image imageButtonNormal;
    private final Image imageButtonActive;
    private int width;
    private int height;
    private Color activeBorderColor = new Color(204, 0, 17);
    private boolean active = false;
    private boolean pushing = false;
    private boolean pushed = false;
    private boolean enabled = true;
    private ArrayList<JCustomListener> actionListeners = new ArrayList();

    public JCustomButton(JCustomEvent.SourceId anId, Image anImageButtonNormal, Image anImageButtonActive, int aWidth, int aHeight) {
        this.id = anId;
        this.imageButtonNormal = anImageButtonNormal;
        this.imageButtonActive = anImageButtonActive;
        this.width = aWidth;
        this.height = aHeight;
        this.setOpaque(false);
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JCustomButton.this.enabled) {
                    JCustomButton.this.requestFocusInWindow();
                    JCustomButton.this.pushing = true;
                    JCustomButton.this.repaint();
                    JCustomEvent event = new JCustomEvent(JCustomButton.this.id, 0);
                    for (JCustomListener listener : JCustomButton.this.actionListeners) {
                        listener.processEvent(event);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JCustomButton.this.pushing = false;
                JCustomButton.this.repaint();
                JCustomEvent event = new JCustomEvent(JCustomButton.this.id, 0);
                event.setType(JCustomEvent.EventType.RELEASE);
                for (JCustomListener listener : JCustomButton.this.actionListeners) {
                    listener.processEvent(event);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (JCustomButton.this.enabled && (e.getKeyCode() == 32 || e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                    JCustomEvent event = new JCustomEvent(JCustomButton.this.id, 0);
                    for (JCustomListener listener : JCustomButton.this.actionListeners) {
                        listener.processEvent(event);
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JCustomButton.this.active = true;
                JCustomButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JCustomButton.this.active = false;
                JCustomButton.this.repaint();
            }
        });
    }

    public void scale(double aScale) {
        this.width = (int)((double)this.width * aScale);
        this.height = (int)((double)this.height * aScale);
        Rectangle b = this.getBounds();
        this.setBounds((int)(b.getX() * aScale), (int)(b.getY() * aScale), this.width, this.height);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setPushed(boolean aPushed) {
        this.pushed = aPushed;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.pushing || this.pushed) {
            g.drawImage(this.imageButtonActive, 0, 0, this.width, this.height, this);
        } else {
            g.drawImage(this.imageButtonNormal, 0, 0, this.width, this.height, this);
        }
        if (this.active && this.enabled) {
            g.setColor(this.activeBorderColor);
            g.drawRect(0, 0, this.width, this.height);
        }
        if (!this.enabled) {
            g.setColor(new Color(0, 0, 0, 64));
            g.fillRect(0, 0, this.width, this.height);
        }
    }

    public void reset() {
        this.pushing = false;
        this.repaint();
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void addGuiListener(JCustomListener l) {
        this.actionListeners.add(l);
    }
}

