/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.jcustomgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class JCustomIndicator
extends JPanel {
    private boolean on = true;
    private boolean active = false;
    private Image indicator_on;
    private Image indicator_off;
    private int width;
    private int height;

    public JCustomIndicator(Image image_on, Image image_off, int aWidth, int aHeight) {
        this.indicator_on = image_on;
        this.indicator_off = image_off;
        this.width = aWidth;
        this.height = aHeight;
        this.setOpaque(false);
    }

    public void scale(double aScale) {
        this.width = (int)((double)this.width * aScale);
        this.height = (int)((double)this.height * aScale);
        Rectangle b = this.getBounds();
        this.setBounds((int)(b.getX() * aScale), (int)(b.getY() * aScale), this.width, this.height);
        this.repaint();
    }

    public void switchValue() {
        this.on = !this.on;
        this.repaint();
    }

    public void setValue(boolean b) {
        this.on = b;
        this.repaint();
    }

    public boolean getValue() {
        return this.on;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.on) {
            g.drawImage(this.indicator_on, 0, 0, this.width, this.height, this);
        } else {
            g.drawImage(this.indicator_off, 0, 0, this.width, this.height, this);
        }
        if (this.active) {
            g.setColor(new Color(255, 0, 0));
            g.drawRect(0, 0, this.width - 1, this.height - 1);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }
}

