/*
 * Decompiled with CFR 0.152.
 */
package org.bjno.jcustomgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JPanel;
import org.bjno.j106.gui.JunoGui;
import org.bjno.jcustomgui.JCustomEvent;
import org.bjno.jcustomgui.JCustomGuiComponent;
import org.bjno.jcustomgui.JCustomListener;

public class JCustomSlider
extends JPanel
implements JCustomGuiComponent {
    private static final int KEY_CHANGE_AMPLITUDE = 1;
    private static final int KEY_CHANGE_AMPLITUDE_FAST = 8;
    private static final double WHEEL_CHANGE_AMPLITUDE = 3.0;
    private boolean active = false;
    private boolean enabled = true;
    private final JCustomEvent.SourceId id;
    private int width;
    private int height;
    private int knobHeight;
    private int knobWidth;
    private int knobOffsetY;
    private int value;
    private int old_value;
    private int dragOffset;
    private boolean dragging = false;
    private double pixelRange;
    private double valueMin;
    private double valueMax;
    private double valueRange;
    private Color activeColor = new Color(204, 0, 17);
    private final Image imageHandleNormal;
    private Rectangle knob;
    private Rectangle bounding_box;
    private Vector<JCustomListener> changeListeners = new Vector();
    private final boolean hasTicks;
    int elasticValue;
    boolean elastic = false;
    boolean mouseWheel = true;
    boolean keyEnabled = true;
    double dragamp = 0.5;
    int dragstart = -1;
    boolean slowchange = false;

    public JCustomSlider(JCustomEvent.SourceId anId, Image anImageHandleNormal, int aWidth, int aHeight, int aKnobWidth, int aKnobHeight, int anExternalMin, int anExternalMax, boolean aHasTicks) {
        this.id = anId;
        this.imageHandleNormal = anImageHandleNormal;
        this.width = aWidth;
        this.height = aHeight;
        this.knobWidth = aKnobWidth;
        this.knobHeight = aKnobHeight;
        this.valueMin = anExternalMin;
        this.valueMax = anExternalMax;
        this.hasTicks = aHasTicks;
        this.pixelRange = this.height - this.knobHeight;
        this.valueRange = this.valueMax - this.valueMin;
        this.knob = new Rectangle(this.knobOffsetY, 0, this.knobWidth, this.knobHeight);
        this.bounding_box = new Rectangle(0, 0, this.knobWidth, this.height);
        this.value = 0;
        this.old_value = 0;
        this.knobOffsetY = 58;
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JCustomSlider.this.dragging) {
                    if (JCustomSlider.this.slowchange) {
                        if (JCustomSlider.this.dragstart == -1) {
                            JCustomSlider.this.dragstart = e.getY();
                        }
                        JCustomSlider.this.setPosition((double)JCustomSlider.this.dragstart + (double)(e.getY() - JCustomSlider.this.dragstart) * JCustomSlider.this.dragamp - (double)JCustomSlider.this.dragOffset);
                    } else {
                        JCustomSlider.this.setPosition((double)e.getY() - (double)JCustomSlider.this.dragOffset);
                    }
                }
            }
        });
        this.addMouseListener(new InternalMouseAdapter());
        this.addMouseWheelListener(new MouseWheelListener(){
            JunoGui.MouseWheelEventFilter filter = new JunoGui.MouseWheelEventFilter();

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (JCustomSlider.this.mouseWheel && JCustomSlider.this.enabled) {
                    if (!this.filter.filterMouseWheelEvent(e)) {
                        return;
                    }
                    JCustomSlider.this.requestFocusInWindow();
                    if (JCustomSlider.this.bounding_box.contains(e.getX(), e.getY())) {
                        double delta = e.getWheelRotation();
                        if (!JCustomSlider.this.hasTicks) {
                            delta *= 3.0;
                        }
                        JCustomSlider.this.setSliderValue(JCustomSlider.this.value - (int)Math.round(delta));
                    }
                }
            }
        });
        this.addKeyListener(new InternalKeyAdapter());
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JCustomSlider.this.active = true;
                JCustomSlider.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JCustomSlider.this.active = false;
                JCustomSlider.this.repaint();
            }
        });
        super.setOpaque(false);
        this.setSliderValue(0);
        this.setFocusable(true);
    }

    public void scale(double aScale) {
        double relativeScale = aScale;
        this.knobWidth = (int)Math.round(relativeScale * (double)this.knobWidth);
        this.knobHeight = (int)Math.round(relativeScale * (double)this.knobHeight);
        this.width = (int)Math.round(relativeScale * (double)this.width);
        this.height = (int)Math.round(relativeScale * (double)this.height);
        this.pixelRange = this.height - this.knobHeight;
        this.knob = new Rectangle(this.knobOffsetY, 0, this.knobWidth, this.knobHeight);
        this.bounding_box = new Rectangle(0, 0, this.knobWidth, this.height);
        this.knobOffsetY = (int)Math.round((this.valueMax - (double)this.value) * this.pixelRange / this.valueRange - this.valueMin);
        this.knob.setLocation(0, this.knobOffsetY);
        Rectangle b = this.getBounds();
        this.setBounds((int)(b.getX() * relativeScale), (int)(b.getY() * relativeScale), this.width, this.height);
        this.repaint();
    }

    public void setKnobHeight(int aKnobHeight) {
        if (this.knobHeight != aKnobHeight) {
            this.knobHeight = aKnobHeight;
            this.pixelRange = this.height - this.knobHeight;
            this.knob = new Rectangle(this.knobOffsetY, 0, this.knobWidth, this.knobHeight);
            this.bounding_box = new Rectangle(0, 0, this.knobWidth, this.height);
            this.knobOffsetY = (int)Math.round((this.valueMax - (double)this.value) * this.pixelRange / this.valueRange - this.valueMin);
            this.knob.setLocation(0, this.knobOffsetY);
            Rectangle b = this.getBounds();
            this.setBounds((int)b.getX(), (int)b.getY(), this.width, this.height);
            this.repaint();
        }
    }

    public void setElastic(boolean b, int val) {
        this.elastic = b;
        this.elasticValue = val;
    }

    public void setKeyEnabled(boolean b) {
        this.keyEnabled = b;
    }

    public void setMouseWheelEnabled(boolean b) {
        this.mouseWheel = b;
    }

    @Override
    public void addGuiListener(JCustomListener l) {
        this.changeListeners.add(l);
    }

    public void setRange(int min, int max) {
        this.valueMin = min;
        this.valueMax = max;
        this.valueRange = this.valueMax - this.valueMin;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.imageHandleNormal, (int)this.knob.getX(), (int)this.knob.getY(), this.knobWidth, this.knobHeight, this);
        if (this.active && this.enabled) {
            g.setColor(this.activeColor);
            g.drawRect((int)this.knob.getX(), (int)this.knob.getY(), (int)this.knob.getWidth(), (int)this.knob.getHeight());
        }
        if (!this.enabled) {
            g.setColor(new Color(0, 0, 0, 64));
            g.fillRect((int)this.knob.getX(), (int)this.knob.getY(), (int)this.knob.getWidth(), (int)this.knob.getHeight());
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        if (v != this.value) {
            if ((double)v > this.valueMax) {
                v = (int)this.valueMax;
            } else if ((double)v < this.valueMin) {
                v = (int)this.valueMin;
            }
            this.old_value = this.value = v;
            this.knobOffsetY = (int)Math.round((this.valueMax - (double)this.value) * this.pixelRange / this.valueRange - this.valueMin);
            this.knob.setLocation(0, this.knobOffsetY);
            this.repaint();
        }
    }

    private void setSliderValue(int v) {
        if ((double)v > this.valueMax) {
            v = (int)this.valueMax;
        } else if ((double)v < this.valueMin) {
            v = (int)this.valueMin;
        }
        this.value = v;
        this.knobOffsetY = (int)Math.round((this.valueMax - (double)this.value) * this.pixelRange / this.valueRange - this.valueMin);
        this.knob.setLocation(0, this.knobOffsetY);
        this.repaint();
        this.evaluateChange();
    }

    private void evaluateChange() {
        if (this.old_value != this.value) {
            this.old_value = this.value;
            JCustomEvent e = new JCustomEvent(this.id, this.value);
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                this.changeListeners.get(i).processEvent(e);
            }
        }
    }

    private void setPosition(int y) {
        this.knobOffsetY = y < 0 ? 0 : (y + this.knobHeight > this.height ? this.height - this.knobHeight : y);
        this.value = (int)this.valueMax - (int)Math.round(this.valueMin + (double)this.knobOffsetY * this.valueRange / this.pixelRange);
        this.knob.setLocation(0, this.knobOffsetY);
        this.repaint();
        this.evaluateChange();
    }

    private void setPosition(double y) {
        double ypos = y < 0.0 ? 0.0 : (y + (double)this.knobHeight > (double)this.height ? (double)(this.height - this.knobHeight) : y);
        this.value = (int)this.valueMax - (int)Math.round(this.valueMin + ypos * this.valueRange / this.pixelRange);
        this.knobOffsetY = (int)Math.round(ypos);
        this.knob.setLocation(0, this.knobOffsetY);
        this.repaint();
        this.evaluateChange();
    }

    class InternalMouseAdapter
    extends MouseAdapter {
        InternalMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (JCustomSlider.this.enabled && JCustomSlider.this.bounding_box.contains(e.getX(), e.getY())) {
                JCustomSlider.this.requestFocusInWindow();
                if (JCustomSlider.this.knob.contains(e.getX(), e.getY())) {
                    JCustomSlider.this.dragOffset = e.getY() - (int)JCustomSlider.this.knob.getLocation().getY();
                    JCustomSlider.this.dragging = true;
                    if (JCustomSlider.this.slowchange) {
                        JCustomSlider.this.dragstart = e.getY();
                    }
                } else {
                    JCustomSlider.this.setPosition(e.getY() - JCustomSlider.this.knobHeight / 2);
                    JCustomSlider.this.dragOffset = 7;
                    JCustomSlider.this.dragging = true;
                    JCustomSlider.this.dragstart = e.getY();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JCustomSlider.this.enabled) {
                JCustomSlider.this.dragging = false;
                JCustomSlider.this.dragstart = -1;
                JCustomSlider.this.slowchange = false;
                if (JCustomSlider.this.hasTicks) {
                    int tmp_val = (int)Math.round((JCustomSlider.this.valueMax - (double)JCustomSlider.this.value) * JCustomSlider.this.pixelRange / JCustomSlider.this.valueRange - JCustomSlider.this.valueMin);
                    JCustomSlider.this.setPosition(tmp_val);
                }
                if (JCustomSlider.this.elastic) {
                    JCustomSlider.this.setSliderValue(JCustomSlider.this.elasticValue);
                }
            }
        }
    }

    class InternalKeyAdapter
    extends KeyAdapter {
        InternalKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (JCustomSlider.this.keyEnabled && JCustomSlider.this.enabled) {
                if (e.getKeyCode() == 16) {
                    JCustomSlider.this.slowchange = true;
                }
                if (e.getKeyCode() == 38) {
                    JCustomSlider.this.setSliderValue(JCustomSlider.this.getValue() + (e.isAltDown() ? 8 : 1));
                }
                if (e.getKeyCode() == 40) {
                    JCustomSlider.this.setSliderValue(JCustomSlider.this.getValue() - (e.isAltDown() ? 8 : 1));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 16 && !JCustomSlider.this.dragging) {
                JCustomSlider.this.slowchange = false;
            }
        }
    }
}

