/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceInfo;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiReceiver;
import uk.co.xfactorylibrarians.coremidi4j.Loader;

public class CoreMidiDestination
implements MidiDevice {
    private CoreMidiDeviceInfo info;
    private final AtomicBoolean isOpen;
    private final AtomicLong startTime;
    private final Set<CoreMidiReceiver> receivers;

    CoreMidiDestination(CoreMidiDeviceInfo info) {
        this.info = info;
        this.isOpen = new AtomicBoolean(false);
        this.startTime = new AtomicLong(0L);
        this.receivers = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    void updateDeviceInfo(CoreMidiDeviceInfo info) {
        this.info = info;
    }

    @Override
    public void open() throws MidiUnavailableException {
        if (this.isOpen.compareAndSet(false, true)) {
            this.startTime.set(this.getMicroSecondTime());
        }
    }

    @Override
    public void close() {
        if (this.isOpen.compareAndSet(true, false)) {
            this.startTime.set(0L);
            for (Receiver receiver : this.getReceivers()) {
                receiver.close();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.getMicroSecondTime() - this.startTime.get();
    }

    public long getStartTime() {
        return this.startTime.get();
    }

    @Override
    public int getMaxReceivers() {
        return -1;
    }

    @Override
    public int getMaxTransmitters() {
        return 0;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        CoreMidiReceiver receiver = new CoreMidiReceiver(this);
        this.receivers.add(receiver);
        return receiver;
    }

    @Override
    public List<Receiver> getReceivers() {
        return Collections.unmodifiableList(new ArrayList<CoreMidiReceiver>(this.receivers));
    }

    void receiverClosed(CoreMidiReceiver receiver) {
        this.receivers.remove(receiver);
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        throw new MidiUnavailableException("CoreMidiDestination has no sources (Transmitters)");
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return Collections.emptyList();
    }

    private native long getMicroSecondTime();

    static {
        try {
            Loader.load();
        }
        catch (Throwable t) {
            System.err.println("Unable to load native library, CoreMIDI4J will stay inactive: " + t);
        }
    }
}

